package dk.aau.create.ooadp.todo;

public class ToDoItem2 implements Comparable<ToDoItem2>{

	private Date deadlineDate;
	private Time deadlineTime;
	private String description;
	private Priority priority;
	private Completion completion;
	
	public ToDoItem2() {};
	
	public ToDoItem2(Date deadlineDate, Time deadlineTime, String description,
			Priority priority, Completion completion) {
		super();
		this.deadlineDate = deadlineDate;
		this.deadlineTime = deadlineTime;
		this.description = description;
		this.priority = priority;
		this.completion = completion;
	}



	public Date getDeadlineDate() {
		return deadlineDate;
	}

	public void setDeadlineDate(Date deadlineDate) {
		this.deadlineDate = deadlineDate;
	}

	public Time getDeadlineTime() {
		return deadlineTime;
	}

	public void setDeadlineTime(Time deadlineTime) {
		this.deadlineTime = deadlineTime;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public Priority getPriority() {
		return priority;
	}

	public void setPriority(Priority priority) {
		this.priority = priority;
	}

	public Completion getCompletion() {
		return completion;
	}

	public void setCompletion(Completion completion) {
		this.completion = completion;
	}

	@Override
	public int compareTo(ToDoItem2 tdi) {
		if (tdi == null) return 1;
		if (this.equals(tdi)) return 0;
		int comp = getDeadlineDate().compareTo(tdi.getDeadlineDate());
		if (comp != 0) return comp;
		comp = getDeadlineTime().compareTo(tdi.getDeadlineTime());
		if (comp != 0) return comp;
		return 0;
	}

	@Override
	public String toString() {
		return "ToDoItem2 [deadlineDate=" + deadlineDate + ", deadlineTime="
				+ deadlineTime + ", description=" + description + ", priority="
				+ priority + ", completion=" + completion + "]";
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (!(obj instanceof ToDoItem2))
			return false;
		ToDoItem2 other = (ToDoItem2) obj;
		if (completion != other.completion)
			return false;
		if (deadlineDate == null) {
			if (other.deadlineDate != null)
				return false;
		} else if (!deadlineDate.equals(other.deadlineDate))
			return false;
		if (deadlineTime == null) {
			if (other.deadlineTime != null)
				return false;
		} else if (!deadlineTime.equals(other.deadlineTime))
			return false;
		if (description == null) {
			if (other.description != null)
				return false;
		} else if (!description.equals(other.description))
			return false;
		if (priority != other.priority)
			return false;
		return true;
	}

	
	
}
