package dk.aau.med4.ooadp.reexam2010;

public class SortedPoint implements Comparable<SortedPoint> {
	public int x, y, z;
	public SortedPoint(int x, int y, int z) {
		this.x = x;
		this.y = y;
		this.z = z;
	}
	
	public boolean equals(Object o) {
		if (!(o instanceof SortedPoint)) return false;
		SortedPoint p = (SortedPoint)o;
		if (p == null) return false;
		if (x != p.x) return false;
		if (y != p.y) return false;
		if (z != p.z) return false;
		return true;
	}
	
	public int compareTo(SortedPoint p) {
		if (equals(p)) return 0;
		int i = x - p.x;
		if (i != 0) return i;
		i = y - p.y;
		if (i != 0) return i;
		i = z - p.z;
		if (i != 0) return i;
		return 0;
	}
	
	public String toString() {
		return "("+x+","+y+","+z+")";
	}
}
