//Tracks the n nearest points in the Kinect's view.
import librarytests.*;
import org.openkinect.*;
import org.openkinect.processing.*;

Kinect kinect;
PImage display;
int[] rawDepthArray;
int w = 640, h = 480;
int n = 5; //The number of nearest points to track.

void setup() {
  size(w,h);
  kinect = new Kinect(this);
  kinect.start();
  kinect.enableDepth(true);
  kinect.processDepthImage(true);
  noStroke();
  fill(255,0,0);
}

void draw() {
  rawDepthArray = kinect.getRawDepth();
  display = kinect.getDepthImage();
  Point[] nearest = new Point[n];
  for(int x = 0; x < w; x++) {
    for(int y = 0; y < h; y++) {
      for(int k = 0; k < n; k++) {
        if (nearest[k] == null || 
            (rawDepthArray[x + y * w] <= nearest[k].d && 
             dist(x,y,nearest[k].x,nearest[k].y) > 10)) { //Ensures points aren't too close together.
          for (int j = n - 2; j >= k; j--)
            nearest[j+1] = nearest[j];
          nearest[k] = new Point(x,y,rawDepthArray[x + y * w]);
          break;
        }
      }
    }
  }
  image(display,0,0);
  if (frameCount % 10 == 0)
    println(nearest);
  for(int k = 0; k < n; k++)
    ellipse(nearest[k].x,nearest[k].y,20,20);
}

void keyPressed() {
  if (key == ENTER) {
    kinect.quit();
    super.stop();
  }
}

