//Tracks the nearest point in the Kinect's view.

//First open the openkinect libraries
import librarytests.*;
import org.openkinect.*;
import org.openkinect.processing.*;

Kinect kinect; //Declare a Kinect object
PImage display;
int[] rawDepthArray;
int w = 640, h = 480;

void setup() {
  size(w,h);
  kinect = new Kinect(this); //Initialize the Kinect object
  kinect.start(); //Start the Kinect object
  kinect.enableDepth(true); //Enable depth detection
  kinect.processDepthImage(true); //Strictly, we don't need this as processDepthImage is true by default.
                                  //We need processDepthImage to be true if we are going to use the
                                  //greyscale depth image.
}

void draw() {
  rawDepthArray = kinect.getRawDepth(); //Get the raw depth data from the sensor for this frame
  display = kinect.getDepthImage(); //Get the image representing depth detection
  int nearestX = 0, nearestY = 0, nearestDistance = 0;
  for(int x = 0; x < w; x++) {
    for(int y = 0; y < h; y++) {
      if (nearestDistance == 0 || (rawDepthArray[x + y * w] < nearestDistance)) {
        nearestDistance = rawDepthArray[x + y * w];
        nearestX = x;
        nearestY = y;
      }
    }
  }
  noStroke();
  fill(255,0,0);
  image(display,0,0);
  ellipse(nearestX,nearestY,20,20);
}

void keyPressed() {
  if (key == ENTER) {
    kinect.quit();
    super.stop();
  }
}


