// this signal uses the mouseX and mouseY position to build a signal
class MouseSaw implements AudioSignal
{
  /**
  Need to override the generate() function for mono and stereo.
  The argument is an array of floats that defines the shape of 
  the waveform.
  */
  void generate(float[] samp)
  {
    float range = map(mouseX, 0, width, 0, 1);
    float peaks = map(mouseY, 0, height, 1, 20);
    float inter = float(samp.length) / peaks;
    for ( int i = 0; i < samp.length; i += inter )
    {
      for ( int j = 0; j < inter && (i+j) < samp.length; j++ )
      {
        samp[i + j] = map(j, 0, inter, -range, range); 
        //straight line from -range to +range of length inter
      }
    }
  }
  
  // the stereo generate method just fills both sides with the same signal
  void generate(float[] left, float[] right)
  {
    generate(left);
    generate(right);
  }
}
