import processing.core.*; 
import processing.xml.*; 

import java.applet.*; 
import java.awt.Dimension; 
import java.awt.Frame; 
import java.awt.event.MouseEvent; 
import java.awt.event.KeyEvent; 
import java.awt.event.FocusEvent; 
import java.awt.Image; 
import java.io.*; 
import java.net.*; 
import java.text.*; 
import java.util.*; 
import java.util.zip.*; 
import java.util.regex.*; 

public class ThumbnailReorder extends PApplet {

String[] playlist_array;
ArrayList<String> playlist;
ArrayList<PImage> imageList = new ArrayList<PImage>();
int thumbnailSize = 100;
boolean imageSelected = false;
int selectedImageIndex = 0;

public void setup() {
/*
Reads playlist file
*/
  playlist_array = loadStrings("playlist");
  playlist = new ArrayList<String>();
  for (String s : playlist_array) playlist.add(s);
  println(playlist);

/*
Loads thumbnail images into an array list
in the order in which they 
appear in the playlist file.
*/
  for(String imageFileName : playlist) {
    String thumbnailFileName = imageFileName.substring(0,imageFileName.length()-4) + "-newthmb.jpg";
    imageList.add(loadImage(thumbnailFileName));
  }
  
  size(5 * thumbnailSize,((imageList.size()/5)+1) * thumbnailSize);
  
  displayPlaylist();

}

public void draw() {
  background(0);
  displayPlaylist();
  if (imageSelected) {
    image(imageList.get(selectedImageIndex),mouseX,mouseY,thumbnailSize-5,thumbnailSize-5);
  }
}

/*
Displays the thumbnails in the
order of the array.
*/

public void displayPlaylist() {
  for(int i = 0; i < imageList.size(); i++) {
    int x = (i % 5) * thumbnailSize;
    int y = (i/5) * thumbnailSize;
    image(imageList.get(i),x,y,thumbnailSize-5,thumbnailSize-5);
  }
}

/*
User can click on a thumbnail,
drag it to a new position and
drop it. This causes
- the image to be inserted at that position
in the display
- the filename to be placed at the
corresponding position in the thumbnail array
- the playlist file to be updated
*/

public void mouseClicked() {
    int x = constrain(mouseX,0,width);
    int y = constrain(mouseY,0,height);
    int imageX = (x/thumbnailSize)*thumbnailSize;
    int imageY = (y/thumbnailSize)*thumbnailSize;
    if (!imageSelected) {
      imageSelected = true;
      selectedImageIndex = (x/thumbnailSize)+((y/thumbnailSize)*5);
    } else {// image selected
      imageSelected = false;
      int newIndex = (x/thumbnailSize)+((y/thumbnailSize)*5);
      //Modify playlist array
      String movedFilename = playlist.get(selectedImageIndex);
      playlist.remove(selectedImageIndex);
      if (newIndex > playlist.size()) 
        playlist.add(movedFilename);
      else
        playlist.add(newIndex,movedFilename);
      //Modify playlist file
      playlist_array = playlist.toArray(playlist_array);
      saveStrings("data/playlist",playlist_array);
      
      //DEBUG
      playlist_array = loadStrings("playlist");
      println();
      println(playlist_array);
      println(playlist);

      //END DEBUG
      
      //Modify imageList
      PImage movedImage = imageList.get(selectedImageIndex);
      imageList.remove(selectedImageIndex);
      if (newIndex > imageList.size())
        imageList.add(movedImage);
      else
        imageList.add(newIndex,movedImage);
      //Redraw display
      displayPlaylist();
    }
}
  static public void main(String args[]) {
    PApplet.main(new String[] { "--bgcolor=#FFFFFF", "ThumbnailReorder" });
  }
}
