import processing.video.*;

PFont f;
Capture video;
String chars = "helloworld";
int pixelsPerChar = 14, w = 640, h = 480;
int cols = w/pixelsPerChar, rows = h/pixelsPerChar;
int charCount = 0;

void setup() {
  size(w,h);
  video = new Capture(this,cols, rows, 15);
  f = createFont("Verdana-Bold",20,true);
  textFont(f,20);
  textAlign(LEFT);
}

void draw() {
  background(0);
  video.loadPixels();
  for(int col = 0; col < cols; col++)
    for(int row = 0; row < rows; row++) {
      color colour = video.pixels[col+row*cols];
      fill(colour);
      text(chars.charAt(charCount),col * pixelsPerChar,row * pixelsPerChar);
      charCount = ++charCount % chars.length();    
    }
}

void captureEvent(Capture video) {
  video.read();
}
