float earthTheta = 0;
float earthMoonTheta = 0;
float marsTheta = 0;
float marsMoon1Theta = 0;
float marsMoon2Theta = 0;

float earthSpeed = radians(1);
float earthMoonSpeed = radians(-2);
float marsSpeed = radians(3);
float marsMoon1Speed = radians(-4);
float marsMoon2Speed = radians(5);


void setup() {
  size(200,200);
  smooth();
}

void draw() {
  earthTheta += earthSpeed;
  earthMoonTheta += earthMoonSpeed;
  marsTheta += marsSpeed;
  marsMoon1Theta += marsMoon1Speed;
  marsMoon2Theta += marsMoon2Speed;
  
  background(255);
  
  //Draw Sun
  translate(width/2,height/2);
  fill(255,255,0);
  ellipse(0,0,20,20);
  
  //Draw Earth
  pushMatrix();//Saves Sun's co-ordinate system
  rotate(earthTheta);
  translate(40,0);
  fill(0,0,255);
  ellipse(0,0,10,10);
  
  //Draw Earth's moon
  pushMatrix(); //Saves Earth's co-ordinate system
  rotate(earthMoonTheta);
  translate(10,0);
  fill(100);
  ellipse(0,0,4,4);
  popMatrix(); //Now back in Earth's co-ordinate system
  
  //Draw Mars
  popMatrix(); //Now back in Sun's co-ordinate system
  pushMatrix(); //Save Sun's co-ordinate system
  rotate(marsTheta);
  translate(75,0);
  fill(255,0,0);
  ellipse(0,0,7,7);
  
  //Draw Mars' first moon
  pushMatrix(); //Save Mars' co-ordinate system
  rotate(marsMoon1Theta);
  translate(10,0);
  fill(200);
  ellipse(0,0,3,3);
  popMatrix(); //Get back to Mars' co-ordinate system
  
  //Draw Mars' second moon
  rotate(marsMoon2Theta);
  translate(15,0);
  fill(150);
  ellipse(0,0,3,3);
  popMatrix();
}
