import processing.video.*;

int pixelsPerCell = 8;
int displayWidth = 320;
int displayHeight = 240;
int numCols = displayWidth / pixelsPerCell;
int numRows = displayHeight / pixelsPerCell;

Capture video;

void setup() {
  size(displayWidth,displayHeight);
  video = new Capture(this, numCols, numRows, 30);
}

void draw() {
  background(0);
  video.loadPixels();
  for(int x = 0; x < numCols; x++)
    for(int y = 0; y < numRows; y++) {
      float displayX = pixelsPerCell * (x+0.5);
      float displayY = pixelsPerCell * (y+0.5);
      float cellWidth = pixelsPerCell * brightness(video.pixels[x + y * video.width])/255.0;
      fill(255);
      stroke(0);
      rect(displayX,displayY,cellWidth, cellWidth);
    }
}

void captureEvent(Capture video) {
  video.read();
}
