import processing.video.*;

int pixelsPerCell = 8;
int displayWidth = 320;
int displayHeight = 240;
int numCols = displayWidth / pixelsPerCell;
int numRows = displayHeight / pixelsPerCell;

Capture video;

void setup() {
  size(displayWidth,displayHeight);
  video = new Capture(this, numCols, numRows, 30);
}

void draw() {
  video.loadPixels();
  for(int x = 0; x < numCols; x++)
    for(int y = 0; y < numRows; y++) {
      int displayX = pixelsPerCell * x;
      int displayY = pixelsPerCell * y;
      color c = video.pixels[x + y * video.width];
      fill(c);
      stroke(0);
      rect(displayX,displayY,pixelsPerCell, pixelsPerCell);
    }
}

void captureEvent(Capture video) {
  video.read();
}
