//Loads an array of images from a folder
//and displays them one after the other

PImage image;
String path = "/Users/dave/Pictures/2009 01 18";
String[] fileNames = listFileNames(path);
int i = 0;
float x, y;

void setup() {
  size(400,400);
  for(String name : fileNames)
    println(name);
}

void draw() {
  if (frameCount % 100 == 0) {
    background(255);
    while (!fileNames[i].endsWith(".jpg"))
      i = (i + 1) % fileNames.length;
    image = loadImage(path+"/"+fileNames[i]);
    if (image.width > image.height) {
      scale(1.0 * width/image.width);
      x = image.width/2.0;
      y = image.width/2.0;
    } else { 
      scale(1.0 * height/image.height);
      x = image.height/2.0;
      y = image.height/2.0;
    }
    imageMode(CENTER);
    image(image,x,y);
    i = (i + 1) % fileNames.length;
  }
}

String[] listFileNames(String dir) {
  File file = new File(dir);
  if (file.isDirectory()) {
    String names[] = file.list();
    return names;
  } else {
    // If it's not a directory
    return null;
  }
}

