import processing.core.*; 
import processing.xml.*; 

import java.applet.*; 
import java.awt.Dimension; 
import java.awt.Frame; 
import java.awt.event.MouseEvent; 
import java.awt.event.KeyEvent; 
import java.awt.event.FocusEvent; 
import java.awt.Image; 
import java.io.*; 
import java.net.*; 
import java.text.*; 
import java.util.*; 
import java.util.zip.*; 
import java.util.regex.*; 

public class SlideShow2 extends PApplet {

//Loads an array of images from a folder
//and displays them one after the other

PImage image;
String path = "/Users/dave/Pictures/2009 01 18";
String[] fileNames = listFileNames(path);
int i = 0;
float x, y;

public void setup() {
  size(400,400);
  for(String name : fileNames)
    println(name);
}

public void draw() {
  if (frameCount % 100 == 0) {
    background(255);
    while (!fileNames[i].endsWith(".jpg"))
      i = (i + 1) % fileNames.length;
    image = loadImage(path+"/"+fileNames[i]);
    if (image.width > image.height) {
      scale(1.0f * width/image.width);
      x = image.width/2.0f;
      y = image.width/2.0f;
    } else { 
      scale(1.0f * height/image.height);
      x = image.height/2.0f;
      y = image.height/2.0f;
    }
    imageMode(CENTER);
    image(image,x,y);
    i = (i + 1) % fileNames.length;
  }
}

public String[] listFileNames(String dir) {
  File file = new File(dir);
  if (file.isDirectory()) {
    String names[] = file.list();
    return names;
  } else {
    // If it's not a directory
    return null;
  }
}

  static public void main(String args[]) {
    PApplet.main(new String[] { "--bgcolor=#FFFFFF", "SlideShow2" });
  }
}
