import ddf.minim.*;

Minim minim;
AudioInput in;
AudioRecorder recorder;
AudioPlayer player;

void setup() {
  size(512, 200, P3D);
  textMode(SCREEN);  
  minim = new Minim(this);
  in = minim.getLineIn(Minim.STEREO, 2048);
  recorder = minim.createRecorder(in, 
                     "myrecording.wav", true);
  textFont(createFont("Arial", 12));
}

void draw() {
  background(0); 
  stroke(255);
  for(int i = 0; i < in.left.size()-1; i++) {
    line(i, 50 + in.left.get(i)*50, 
         i+1, 50 + in.left.get(i+1)*50);
    line(i, 150 + in.right.get(i)*50, 
         i+1, 150 + in.right.get(i+1)*50);
  }
  if (recorder.isRecording())
    text("Now recording...", 5, 15);
  else
    text("Not recording.", 5, 15);
}

void keyReleased() {
  if ( key == 'r' ) {
    if (recorder.isRecording()) 
      recorder.endRecord();
    else 
      recorder.beginRecord();
  }
  if ( key == 's' ) {
    if ( player != null )
        player.close();
    recorder.save();
    player = minim.loadFile("myrecording.wav");
    player.play();
  }
}

void stop() {
  in.close();
  if ( player != null )
    player.close();
  minim.stop();
  super.stop();
}
