int modulus = 12;
int[] pcset = {
  1,3,5,9};
int w = 800;
int originx = w/2;
int originy = w/2;
float radius = w * .3;
int pcRadius = min(20,w*8/(5*modulus));
int fontsize = (int)(pcRadius * .6);
float dlenSpacing = radius*0.9/(1.0*pcset.length/2);
float springOffset = dlenSpacing/(1+pcset.length);
float springSpacing = radius * 0.95/(0.6*pcset.length*pcset.length);

void setup() {
  pcset = sort(pcset);
  PFont font;
  font = createFont("TimesNewRoman",fontsize); 
  textFont(font);
  textAlign(CENTER,CENTER);

  smooth();
  background(255);
  size(w,w);
  drawChromaticCircle();
  drawPCSet();

  drawSprings();
}


void drawChromaticCircle() {
  for(int i = 0; i < modulus; i++) {
    int x = originx+(int)(radius*Math.sin(i*TWO_PI/modulus));
    int y = originy-(int)(radius*Math.cos(i*TWO_PI/modulus));
    drawPCCircle(i,x,y,false);
    writePitchClass(i,x,y,0);
  }
}

void writePitchClass(int i,int x,int y,int col) {
  fill(col);
  text(i,x+0.05*pcRadius,y-0.05*pcRadius);
}

void drawPCCircle(int i, int x, int y, boolean occupied) {
  if (occupied) {
    stroke(0);
    line(originx,originy,x,y);
    fill(0);
  } 
  else
    noFill();
  stroke(0);
  ellipse(x,y,pcRadius,pcRadius);
  if (occupied) {
    writePitchClass(i,x,y,255); 
  }
}

void drawPCSet() {
  for(int i = 0; i < pcset.length; i++) {
    int x = originx+(int)(radius*Math.sin(pcset[i]*TWO_PI/modulus));
    int y = originy-(int)(radius*Math.cos(pcset[i]*TWO_PI/modulus));
    drawPCCircle(pcset[i],x,y,true);
  }
}

void drawSprings() {
  noFill();
  float unevenness = 0.0f;
  int unevennessNumerator = 0;

  int potDen = pcset.length * modulus;
  potDen *= potDen;  
  for (int i = 0; i < pcset.length - 1; i++) {
    for(int j = i + 1; j < pcset.length; j++) {
      int clockwiseFromI = pcset[j] - pcset[i];
      int clockwiseFromJ = pcset[i]+modulus - pcset[j];
      int clen = min(clockwiseFromI,clockwiseFromJ);
      int dlen = j - i;
      if (clockwiseFromJ < clockwiseFromI)
        dlen = i + pcset.length - j;
      else if (clockwiseFromJ == clockwiseFromI)
        dlen = min(dlen,i + pcset.length - j);
      int sqrtPotNum = (clen * pcset.length) - (dlen * modulus);
      int potNum = sqrtPotNum * sqrtPotNum;
      float potential = 1.0*potNum/potDen;
      unevenness += potential;
      unevennessNumerator += potNum;
      //      float redComponent = potential * 255;
      //      float blueComponent = (1 - potential) * 255;
      //      stroke(redComponent, 0.0, blueComponent);
      //      stroke(constrain(potential * 200,0,200));
      if (sqrtPotNum < 0) {
        stroke(0);
        strokeWeight(2);
      }
      else if (sqrtPotNum > 0) {
        stroke(120);
        strokeWeight(1);
        //stroke(0,0,255/*constrain(potNum*potNum,0,255)*/);
      }
      else {
        stroke(0);
        strokeWeight(1);
      }
      float iAngle = pcset[i] * (TWO_PI/modulus) - (PI/2);
      float jAngle = pcset[j] * (TWO_PI/modulus) - (PI/2);
      float startAngle, stopAngle;
      float clockwiseOffset = 0.0;
      float cw = 0.0;
      if (clockwiseFromJ < clockwiseFromI) {
        clockwiseOffset = 0.5 * springOffset;
        cw = 0.5;
        startAngle = jAngle;
        stopAngle = (iAngle < jAngle)?iAngle+TWO_PI:iAngle;
      } 
      else if (clockwiseFromI < clockwiseFromJ) {
        startAngle = iAngle;
        stopAngle = (jAngle < iAngle)?jAngle + TWO_PI:jAngle;
      } 
      else { // so clockwiseFromI == clockwiseFromJ
        if (j - i <= i + pcset.length - j) {
          startAngle = iAngle;
          stopAngle = (jAngle < iAngle)?jAngle+TWO_PI:jAngle;
        } 
        else { // j - i > i + pcset.length - j
          clockwiseOffset = 0.5 * springOffset;
          cw = 0.5;
          startAngle = jAngle;
          stopAngle = (iAngle < jAngle)?iAngle+TWO_PI:iAngle;
        }
      }

//      arc((float)originx,(float)originy,dlen*dlenSpacing+(i*springOffset)+clockwiseOffset,dlen*dlenSpacing+(i*springOffset)+clockwiseOffset,startAngle,stopAngle);
      float arcRadius = radius*.2+(i * pcset.length + j + cw)*springSpacing;
      arc((float)originx,(float)originy,arcRadius,arcRadius,startAngle,stopAngle);    }
  }
  fill(0);
  String unevennessString = String.format("%.4f",unevenness);
  //text("Unevenness = "+unevennessString/*+"\nNumerator = "+unevennessNumerator+"\n"+"Denominator = "+potDen*/,w/2,3*w/4+radius/2);
}






