
import king.kinect.*;

PImage img, depth;

void setup()
{
  size(1280, 480);
  
  NativeKinect.init();
  NativeKinect.start();
  
  img = createImage(640,480,RGB);
  depth = createImage(640,480,RGB);
}

void draw()
{
  img.pixels = NativeKinect.getVideo();
  img.updatePixels();
  image(img,0,0,640,480);

  depth.pixels = NativeKinect.getDepthMap();

  int nearest = -1;
  for(int i = 0; i < depth.pixels.length; i++) {
    if (i == 0 || depth.pixels[i] < depth.pixels[nearest]) {
      nearest = i;
    }
  }

  depth.updatePixels();
  image(depth,640,0,640,480);
  
  
  int x = nearest % 640;
  int y = nearest / 640;
  fill(255,0,0);
  ellipse(x,y,20,20);
}


