import processing.video.*;

Capture video;
PImage prevFrame;
int vidW = 320, vidH = 240;
float maxDist = dist(0,0,0,255,255,255);

void setup() {
  size(vidW,vidH);
  video = new Capture(this, vidW, vidH, 30);
  prevFrame = createImage(vidW, vidH, RGB);
}

void draw() {
  background(0);
  loadPixels();
  video.loadPixels();
  prevFrame.loadPixels();
  for(int x = 0; x < vidW; x++)
    for(int y = 0; y < vidH; y++) {
      int loc = x + y * vidW;
      color thisPixel = video.pixels[loc];
      color prevPixel = prevFrame.pixels[loc];
      float distance = dist(red(prevPixel), green(prevPixel), blue(prevPixel),
                            red(thisPixel), green(thisPixel), blue(thisPixel));
      pixels[loc] = color(255.0 * distance/maxDist);
    }
  updatePixels();
}

void captureEvent(Capture video) {
  prevFrame.copy(video,0,0,vidW,vidH,0,0,vidW,vidH);
  prevFrame.updatePixels();
  video.read();
}
