import ddf.minim.*;

Minim minim;
AudioPlayer groove;

void setup() {
  size(512, 200);
  minim = new Minim(this);
  groove = minim.loadFile("groove.mp3");
  groove.loop();
}

void draw() {
  background(0);
  stroke(255);
  for ( int i = 0; i < groove.bufferSize() - 1; i++ ) {
    float x1 = map(i, 0, groove.bufferSize(), 0, width);
    float y1Left = map(groove.left.get(i), -1, 1, height/2, 0);
    float y1Right = map(groove.right.get(i), -1, 1, height, height/2);
    float x2 = map(i+1, 0, groove.bufferSize(), 0, width);
    float y2Left = map(groove.left.get(i+1), -1, 1, height/2, 0);
    float y2Right = map(groove.right.get(i+1), -1, 1, height, height/2);
    line(x1,y1Left,x2,y2Left);
    line(x1,y1Right,x2,y2Right);
  }
}

void stop() {
  groove.close();
  minim.stop();
  super.stop();
}
