//Audio input

import ddf.minim.*;
import ddf.minim.signals.*;
import ddf.minim.analysis.*;
import ddf.minim.effects.*;

Minim minim;
AudioInput in;
FFT fft; //Need to declare an FFT object to draw an FFT.
int xAxis1 = 50; //y value of x axis for left channel
int xAxis2 = 150;//y value for x axis for right channel
int yScaleFactor = 50; //Enlargement scale factor in y direction

void setup() {
  size(512, 200);
  minim = new Minim(this);
  // get a line in from Minim, 
  // default sample rate is 44100, bit depth is 16
  in = minim.getLineIn(Minim.STEREO, 512);
  fft = new FFT(in.bufferSize(), in.sampleRate());
}

void draw() {
  background(0);

  //Do an FFT on one of the three buffers in the 
  //AudioInput object
  stroke(255);
  fft.forward(in.mix);
  for(int i = 0; i < fft.specSize();i++) {
    line(2*i,height,2*i, height - fft.getBand(i)* 8);
  }  

  stroke(255);
  for(int i = 0; i < in.bufferSize() - 1; i++) {
    //Draw left channel
    line(i, xAxis1 - in.left.get(i) * yScaleFactor, 
    i+1, xAxis1 - in.left.get(i+1) * yScaleFactor);
    //Draw right channel
    line(i, xAxis2 - in.right.get(i) * yScaleFactor, 
    i+1, xAxis2 - in.right.get(i+1) * yScaleFactor);
  }
}

void stop()
{
  in.close();
  minim.stop();
  super.stop();
}

