//Synthesizing sound

//Following import lines import Minim library
import ddf.minim.*;
import ddf.minim.signals.*;
import ddf.minim.analysis.*;
import ddf.minim.effects.*;

Minim minim;
FFT fft; //Need to declare an FFT object to draw an FFT.
int xAxis1 = 50; //y value of x axis for left channel
int xAxis2 = 150;//y value for x axis for right channel
int yScaleFactor = 50; //Enlargement scale factor in y direction

AudioOutput out;
SquareWave squareWave;
LowPassSP lowPass;

void setup() {
  size(512, 300);
  minim = new Minim(this);

  //Get a stereo line out with a buffer size of 512
  out = minim.getLineOut(Minim.STEREO, 512);
  //With no args, get a stereo line out with a buffer size of 1024.
  //out = minim.getLineOut();
  
  //  Initialize an FFT by giving it the buffer size
  //  of the current audio source and the sample rate.
  fft = new FFT(out.bufferSize(), out.sampleRate());

  squareWave = new SquareWave(220,1,44100);
  lowPass = new LowPassSP(400,44100);
  out.addSignal(squareWave);
  out.addEffect(lowPass);
}

void draw() {
  background(0);
  
  //Do an FFT on one of the three buffers in the 
  //AudioOutput object
  stroke(255);
  fft.forward(out.mix);
  for(int i = 0; i < fft.specSize();i++) {
    line(2*i,height,2*i, height - fft.getBand(i)* 8);
  }  
  
  stroke(255);
  for(int i = 0; i < out.bufferSize() - 1; i++) {
    //Draw left channel
    line(i, xAxis1 - out.left.get(i) * yScaleFactor, 
         i+1, xAxis1 - out.left.get(i+1) * yScaleFactor);
    //Draw right channel
    line(i, xAxis2 - out.right.get(i) * yScaleFactor, 
         i+1, xAxis2 - out.right.get(i+1) * yScaleFactor);
  }
}

void keyPressed() {
  if (key == 'e') {
    if (out.isEnabled(lowPass))
      out.disableEffect(lowPass);
    else
      out.enableEffect(lowPass);
  }
  if (key == 'm') {
    if (out.isMuted())
      out.unmute();
    else
      out.mute();
  }
}

/**
Overriding the PApplet stop() method so that
we also close the AudioPlayer and stop Minim.
*/
void stop() {
  out.close();
  minim.stop();
  super.stop();
}

