//Drawing a waveform

//Following import lines import Minim library
import ddf.minim.*;
import ddf.minim.signals.*;
import ddf.minim.analysis.*;
import ddf.minim.effects.*;

Minim minim;
AudioPlayer player;
AudioMetaData meta;
int xAxis1 = 50; //y value of x axis for left channel
int xAxis2 = 150;//y value for x axis for right channel
int yScaleFactor = 50; //Enlargement scale factor in y direction

void setup() {
  size(512, 200);
  minim = new Minim(this);
  // specify 512 for the length of the sample buffers
  // the default buffer size is 1024
  player = minim.loadFile("test.wav", 512);
  player.play();
}

void draw() {
  background(0);
  stroke(255);
  for(int i = 0; i < player.bufferSize() - 1; i++) {
    //Draw left channel
    line(i, xAxis1 - player.left.get(i) * yScaleFactor, 
         i+1, xAxis1 - player.left.get(i+1) * yScaleFactor);
    //Draw right channel
    line(i, xAxis2 - player.right.get(i) * yScaleFactor, 
         i+1, xAxis2 - player.right.get(i+1) * yScaleFactor);
  }
}

/**
Overriding the PApplet stop() method so that
we also close the AudioPlayer and stop Minim.
*/
void stop() {
  player.close();
  minim.stop();
  super.stop();
}

