//Retrieving and displaying metadata

//Play an audio file
//Following import lines import Minim library
import ddf.minim.*;
import ddf.minim.signals.*;
import ddf.minim.analysis.*;
import ddf.minim.effects.*;

Minim minim;
AudioPlayer player;
AudioMetaData meta;

void setup() {
  size(100,100);
  minim = new Minim(this);
  player = minim.loadFile("test.mp3");
  meta = player.getMetaData();
  
  println("File Name: " + meta.fileName());
  println("Length (in milliseconds): " + meta.length());
  println("Title: " + meta.title());
  println("Author: " + meta.author());
  println("Album: " + meta.album());
  println("Date: " + meta.date());
  println("Comment: " + meta.comment());
  println("Track: " + meta.track());
  println("Genre: " + meta.genre());
  println("Copyright: " + meta.copyright());
  println("Disc: " + meta.disc());
  println("Composer: " + meta.composer());
  println("Orchestra: " + meta.orchestra());
  println("Publisher: " + meta.publisher());
  println("Encoded: " + meta.encoded());

}

/**
Overriding the PApplet stop() method so that
we also close the AudioPlayer and stop Minim.
*/
void stop() {
  player.close();
  minim.stop();
  super.stop();
}

