//Two patterns with identical deep structures
//and completely different surfaces.

void setup() {
  size(400,200);
  smooth();
  background(255);
  int radius = 80;
  
  //Pattern 1
  pushMatrix();
  translate(100,100);
  for(int i = 0; i < 4; i++) {
    rotate(PI/2);
    line(0,0,0,radius);
  }
  popMatrix();
  pushMatrix();
  translate(50,50); 
  for(int x = 0; x < 2; x++) {
    for(int y = 0; y < 2; y++) {
      pushMatrix();
      translate(x * 100, y * 100);
      ellipse(0,0,radius/5,radius/2);
      popMatrix();
    }
  }
  popMatrix();
  
  //Pattern 2
  pushMatrix();
  translate(300,100);
  for(int i = 0; i < 4; i++) {
    rotate(PI/2);
    ellipse(radius/2,0,radius,radius/5);
  }
  translate(-50,-50); 
  rectMode(CENTER);
  for(int x = 0; x < 2; x++) {
    for(int y = 0; y < 2; y++) {
      pushMatrix();
      translate(x * 100, y * 100);
      rect(0,0,radius/5,radius/2);
      popMatrix();
    }
  }
  popMatrix();
  
}
