import s373.flob.*;

import processing.video.*;

/*
Take input from the camera.
Identify moving objects in the image.
Project a silhouette of each moving object.
Gradually change each silhouette into another shape.
*/

Capture video;


void setup() {
  size(320,240);
  video = new Capture(this, 320, 240, 30);
}

void draw() {
  video.loadPixels();
  for(int x = 0; x < width; x++) {
    for(int y = 0; y < height; y++) {
        int i = x + y * width;
        color c = video.pixels[i];
        video.pixels[i] = color(green(c),blue(c),red(c));
    }
  }
  video.updatePixels();
  image(video,0,0);
}

void captureEvent(Capture video) {
  video.read();
}
