//Plots intervals as horizontal lines.
import ddf.minim.*;
import ddf.minim.signals.*;
import ddf.minim.analysis.*;
import ddf.minim.effects.*;

Minim minim;
int bufferSize = 512;
AudioInput in;
FFT fft; //Need to declare an FFT object to draw an FFT.
float[] intervalArray = new float[bufferSize];

void setup() {
  for(int i = 0; i < bufferSize; i++)
    intervalArray[i] = 0.0;
  size(bufferSize, bufferSize);
  minim = new Minim(this);
  // get a line in from Minim, 
  // default sample rate is 44100, bit depth is 16
  in = minim.getLineIn(Minim.STEREO, bufferSize);
  fft = new FFT(in.bufferSize(), in.sampleRate());
  noStroke();
  frameRate(10);
}

void draw() {
  background(0);

  //Do an FFT on one of the three buffers in the 
  //AudioInput object
  fft.forward(in.mix);
  for(int i = 0; i < fft.specSize();i++) {
    for(int j = i+1; j < fft.specSize(); j++) {
      intervalArray[j-i] += (fft.getBand(i)*fft.getBand(j));
    }
  }
  for(int i = 0; i < fft.specSize();i++) {
    fill(intervalArray[i]);
    rect(0, bufferSize - 2 * i, bufferSize, 2);
  }
}

void stop()
{
  in.close();
  minim.stop();
  super.stop();
}

