//Plots connections between bands as points in an imagemap.
import ddf.minim.*;
import ddf.minim.signals.*;
import ddf.minim.analysis.*;
import ddf.minim.effects.*;

Minim minim;
int bufferSize = 512;
AudioInput in;
FFT fft; //Need to declare an FFT object to draw an FFT.
float[][] intervalArray = new float[bufferSize][bufferSize];

void setup() {
  for(int i = 0; i < bufferSize; i++)
    for(int j = 0; j < bufferSize; j++)
      intervalArray[i][j] = 0.0;
  size(bufferSize, bufferSize);
  minim = new Minim(this);
  // get a line in from Minim, 
  // default sample rate is 44100, bit depth is 16
  in = minim.getLineIn(Minim.STEREO, bufferSize);
  fft = new FFT(in.bufferSize(), in.sampleRate());
  noStroke();
  frameRate(10);
}

void draw() {
  background(0);

  //Do an FFT on one of the three buffers in the 
  //AudioInput object
  fft.forward(in.mix);
  for(int i = 0; i < fft.specSize();i++) {
    for(int j = i+1; j < fft.specSize(); j++) {
      intervalArray[i][j] += (fft.getBand(i)*fft.getBand(j));
      fill(intervalArray[i][j]);
      rect(2 * i, bufferSize - 2*j, 2, 2);
    }
  }
}

void stop()
{
  in.close();
  minim.stop();
  super.stop();
}

