import ddf.minim.*;
import ddf.minim.signals.*;
import ddf.minim.analysis.*;
import ddf.minim.effects.*;

Minim minim;
int bufferSize = 512;
AudioInput in;
FFT fft; //Need to declare an FFT object to draw an FFT.
float[] bandArray = new float[bufferSize];

void setup() {
  for(int i = 0; i < bandArray.length; i++)
    bandArray[i] = 0.0;
  size(bufferSize, bufferSize);
  minim = new Minim(this);
  // get a line in from Minim, 
  // default sample rate is 44100, bit depth is 16
  in = minim.getLineIn(Minim.STEREO, bufferSize);
  fft = new FFT(in.bufferSize(), in.sampleRate());
}

void draw() {
  background(0);

  //Do an FFT on one of the three buffers in the 
  //AudioInput object
  fft.forward(in.mix);
  for(int i = 0; i < fft.specSize();i++) {
    bandArray[i] += fft.getBand(i);
    stroke(bandArray[i]);
    line(0, bufferSize - i, bufferSize, bufferSize - i);
  }  
}

void stop()
{
  in.close();
  minim.stop();
  super.stop();
}

