import king.kinect.*;

PImage img, depth;
short[] rawDepth;

void setup()
{
  size(1280, 480);

  img = createImage(640, 480, RGB);
  depth = createImage(640, 480, RGB);

  NativeKinect.init();
  NativeKinect.setVideoIR(); // View the IR images, see also setVideoRGB()

  NativeKinect.start();
}

void draw()
{
  img.pixels = NativeKinect.getVideo();
  img.updatePixels();

  depth.pixels = NativeKinect.getDepthMap();
  depth.updatePixels();

  rawDepth = NativeKinect.getDepthMapRaw();
  println( rawDepth[0] );

  int nearest = -1;
  for(int i = 0; i < rawDepth.length; i++) {
    if (i == 0 || rawDepth[i] < rawDepth[nearest])
      nearest = i;
  }

  int x = nearest % 640;
  int y = nearest / 640;
  image(img, 0, 0, 640, 480);
  image(depth, 640, 0, 640, 480);
  ellipse(x,y,20,20);
}

