import org.openkinect.*;
import org.openkinect.processing.*;

Kinect kinect;
float deg = 15;

void setup() {
  size(640, 480);
  kinect = new Kinect(this);
  kinect.start();
  kinect.enableRGB(true);
  kinect.tilt(deg);
}

void draw() {
  background(0);
  image(kinect.getVideoImage(), 0, 0);
}

void keyPressed() {
  if (keyCode == UP) {
    deg = constrain(deg + 2, -30, 30);
    kinect.tilt(deg);
    println(deg);
  }
  if (keyCode == DOWN) {
    deg = constrain(deg - 2, -30, 30);
    kinect.tilt(deg);
    println(deg);
  }
}

void stop() {
  kinect.quit();
  super.stop();
}

