import org.openkinect.*; import org.openkinect.processing.*;
Kinect kinect;
int w, h;

void setup() {
  size(640,480);
  kinect = new Kinect(this);
  kinect.start();
  kinect.enableDepth(true);
  kinect.enableRGB(true);
  PImage img = kinect.getVideoImage();
  w = img.width; h = img.height;
}

void draw() {
  background(0);
  kinect.processDepthImage(false);
  int[] depth = kinect.getRawDepth();
  int leastDepth = -1;
  for(int i = 0; i < depth.length; i++) {
    if (i == 0 || depth[i] < depth[leastDepth])
      leastDepth = i;
  }
  image(kinect.getVideoImage(),0,0);
  int leastY = leastDepth/w; int leastX = leastDepth % w;
  fill(255,0,0);
  ellipse(leastX,leastY,20,20);
}

void stop() {
  kinect.quit(); super.stop();
}
