class Circle {
  float r;
  float x, y;
  float xSpeed, ySpeed;
  int xDirection = 1;
  int yDirection = 1;

  Circle(float x, float y, float radius, float xSpeed, float ySpeed) {
    this.x = x;
    this.y = y;
    this.xSpeed = xSpeed;
    this.ySpeed = ySpeed;
    r = radius;
  }

  void move() {
    if (x+r > width || x-r < 0)
      xDirection *= -1;
    if (y+r > height || y-r < 0)
      yDirection *= -1;
    x += xSpeed * xDirection;
    y += ySpeed * yDirection;
  }
  
  void display(color c) {
    fill(c);
    stroke(c);
    ellipse(x,y,r*2,r*2);
  }
  
  boolean intersects(Circle c) {
    if (c.r + r > dist(c.x,c.y,x,y))
      return true;
    return false;
  }

}

