import processing.video.*;

Capture video;
int vidWidth = 320, vidHeight = 240;
float maxDist;

void setup() {
  size(vidWidth,vidHeight);
  video = new Capture(this, vidWidth, vidHeight, 30);
  maxDist = 50;
}

void draw() {
  background(255);
  loadPixels();// Loads pixel array for display
  video.loadPixels(); //Loads pixel array for video
  for (int x = 0; x < width; x++)
    for(int y = 0; y < height; y++) {
      int loc = x + y * video.width;
      float r = red(video.pixels[loc]);
      float g = green(video.pixels[loc]);
      float b = blue(video.pixels[loc]);
      float brightnessFactor = 2 - dist(mouseX,mouseY,x,y)/maxDist;
      r = constrain(r*brightnessFactor,0,255);
      g = constrain(g*brightnessFactor,0,255);
      b = constrain(b*brightnessFactor,0,255);
      pixels[loc] = color(r,g,b);
    }
  updatePixels();// Updates pixel array for display
}

void captureEvent(Capture video) {
  video.read();
}

