import processing.pdf.*;

float f = 50.0;
float originX = 100;
float originY = 650;
PFont font = createFont("Times-Roman", 24, true);

void setup() {
  size(700,930,PDF, "ISMIR2012VectorExample.pdf");
  smooth();
  background(255);
  fill(0);
  textFont(font);
  noLoop();
}

void draw() {
  arrow(0,0,2,3);
  arrow(0,3,2,5);
  arrow(2,0,5,3);
  arrow(2,3,5,5);
  thickLine(0,0,8,0);
  thickLine(0,0,0,9);
  mediumLine(2,0,2,9);
  mediumLine(5,0,5,9);
  mediumLine(7,0,7,9);
  mediumLine(0,3,8,3);
  mediumLine(0,5,8,5);
  mediumLine(0,8,8,8);
  thinLine(0,1,8,1);
  thinLine(0,2,8,2);
  thinLine(0,4,8,4);
  thinLine(0,6,8,6);
  thinLine(0,7,8,7);
  thinLine(0,9,8,9);
  thinLine(1,0,1,9);
  thinLine(3,0,3,9);
  thinLine(4,0,4,9);
  thinLine(6,0,6,9);
  thinLine(8,0,8,9);
  drawTickerMarks();
  drawAxisValuesAndLabels();
  drawEquations();
  exit();
}

void drawEquations() {
  pushMatrix();
  textAlign(LEFT,BASELINE);
  translate(originX,originY+150);
  text("v = <1,1,<<0,<2,3>>>,<<0,<3,2>>>>",0,0);
  text("T(<0,0>,v) = <2,3>    (v is <2,3> in note space)",0,30);
  text("T(<2,0>,v) = <5,3>    (v is <3,3> in note space)",0,60);
  text("T(<0,3>,v) = <2,5>    (v is <2,2> in note space)",0,90);
  text("T(<2,3>,v) = <5,5>    (v is <3,2> in note space)",0,120);
  popMatrix();
}

void drawTickerMarks() {
  for(int x = 0; x < 9; x++) {
    graphLine(x,0,x,-.2,1);
  }
  for(int y = 0; y < 10; y++) {
    graphLine(0,y,-.2,y,1);
  }
}

void drawAxisValuesAndLabels() {
  pushMatrix();
  translate(originX,originY);
  textAlign(CENTER,TOP);
  Mask mask = new Mask(0,2,3);
  for(int x = 0; x < 9; x++) {
    text(x,x*f,.3*f);
    Integer v = mask.mask(x); 
    if (v != null) {
      text(v,x*f,.8*f);
    }
  }
  textAlign(RIGHT,CENTER);
  mask = new Mask(0,3,2);
  for(int y = 0; y < 10; y++) {
    text(y,-0.3*f,-y*f);
    Integer v = mask.mask(y); 
    if (v != null) {
      text(v,-.8*f,-y*f);
    }
  }
  pushMatrix();
  translate(-1.6*f, -4.5*f);
  rotate(3*PI/2);
  textAlign(CENTER,CENTER);
  text("pitch",0,0);
  popMatrix();
  
  pushMatrix();
  translate(4*f,1.5*f);
  textAlign(CENTER,CENTER);
  text("time",0,0);
  popMatrix();
  
  pushMatrix();
  translate(8.5*f,.8*f);
  textAlign(LEFT,TOP);
  text("<< 0, < 2, 3 >>>",0,0);
  popMatrix();

  pushMatrix();
  translate(-0.8*f,-9.5*f);
  rotate(3 * PI/2);
  textAlign(LEFT,BASELINE);
  text("<< 0, < 3, 2 >>>",0,0);
  popMatrix();
  
  
  popMatrix();
}

void thickLine(float x1, float y1, float x2, float y2) {
  graphLine(x1, y1, x2, y2,4);
}

void thinLine(float x1, float y1, float x2, float y2) {
  graphLine(x1, y1, x2, y2,.5);
}

void mediumLine(float x1, float y1, float x2, float y2) {
  graphLine(x1, y1, x2, y2,2);
}


void graphLine(float x1, float y1, float x2, float y2, float weight) {
  strokeWeight(weight);
  pushMatrix();
  translate(originX,originY);
  line(x1*f,-y1*f,x2*f,-y2*f);
  popMatrix();  
}

void arrow(float x1, float y1, float x2, float y2) {
  graphLine(x1,y1,x2,y2,1.5);
  pushMatrix();
  translate(originX,originY);
  translate(x2*f,-y2*f);
  rotate(atan((y1-y2)/(x2-x1)));
  beginShape();
    vertex(0,0);
    vertex(-10,7);
    vertex(-10,-7);
  endShape(CLOSE);
  popMatrix();
}
