PFont font = createFont("Times-Roman", 12);
PFont italic = createFont("Times-Italic",12);

void setup() {
  size(780, 240);
  smooth();
  background(255);
  fill(0);
  textFont(font);
  noLoop();
}

void draw() {
  line(30,45,30,180);
  line(650,45,650,180);
  for (int i = 0; i < 3; i++) {
    line(30, i*60 + 45, 650, i*60 + 45);
    line(30, i*60 + 60, 650, i*60 + 60);
  }

  //Number lines
  textAlign(CENTER, BOTTOM);
  for (int i = -6; i < 25; i++) {
    for (int j = 1; j < 4; j++)
      text(i, (i+6)*20+40, j*60);
  }

  //lines for first mask
  Mask mask = new Mask(3, 2, 2, 1, 2, 2, 2, 1);

  for (int i = -6; i < 25; i++) {
    Integer k = mask.mask(i);
    println(i+","+k);
    if (k != null) {
      int x1 = (i+6)*20 + 40;
      int y1 = 60;
      int x2 = (k+6)*20 + 40;
      int y2 = 105;
      ellipse(x1,y1,3,3);
      ellipse(x2,y2,3,3);
      line(x1, y1, x2, y2);
    }
  }

  //lines for second mask
  Mask mask2 = new Mask(4,2,2,3);

  for (int i = -6; i < 25; i++) {
    Integer k = mask2.mask(i);
    println(i+","+k);
    if (k != null) {
      int x1 = (i+6)*20 + 40;
      int y1 = 120;
      int x2 = (k+6)*20 + 40;
      int y2 = 165;
      ellipse(x1,y1,3,3);
      ellipse(x2,y2,3,3);
      line(x1, y1, x2, y2);
    }
  }

  
  //Mask texts
  textAlign(LEFT,CENTER);
  textFont(italic);
  text("Masks",660,40);
  textFont(font);
  text(mask.toString(),660,80);
  text(mask2.toString(),660,140);

  //MASK and UNMASK 
  pushMatrix();
  translate(5,114);
  rotate((PI*3)/2);
  textAlign(CENTER,CENTER);
  text("MASK",0,0);
  text("UNMASK",0,15);
  line(20,0,69,0);
  line(-20,0,-67,0);
  beginShape();
    vertex(-67,0);
    vertex(-63,3);
    vertex(-63,-3);
  endShape(CLOSE);
  line(28,15,69,15);
  line(-28,15,-67,15);
  beginShape();
    vertex(67,15);
    vertex(63,12);
    vertex(63,18);
  endShape(CLOSE);
}

