PImage source, destination;
// Sharpening matrix
//float[][] matrix = {{-1,-1,-1},
//                    {-1, 9,-1},
//                    {-1,-1,-1}};
// Blur matrix
//float[][] matrix = {{1.0/9,1.0/9,1.0/9},
//                    {1.0/9,1.0/9,1.0/9},
//                    {1.0/9,1.0/9,1.0/9}};
// Vertical bar detector
//float[][] matrix = {{-2.5,5,-2.5},
//                    {-2.5,5,-2.5},
//                    {-2.5,5,-2.5}};
// Sharpening matrix
float[][] matrix = {{-2,-2,-2},
                    {-2, 18,-2},
                    {-2,-2,-2}};
                    

void setup() {
  source = loadImage("redcar-small.jpg");
  size(source.width, source.height);
  destination = createImage(source.width, source.height, RGB);
  noLoop();
}

void draw() {
  source.loadPixels();
  destination.loadPixels();
  for(int x = 0; x < source.width; x++) {
    for(int y = 0; y < source.height; y++)
      destination.pixels[x + y * source.width] = sharpen(x,y);
  }
  destination.updatePixels();
  image(destination,0,0);
  save("redcar-convolute.jpg");
}

color sharpen(int x,int y) {
  float r = 0, g = 0, b = 0;
  for(int col = 0; col < 3; col++) {
    for(int row = 0; row < 3; row++) {
      int x2 = x + col - 1, y2 = y + row - 1;
      if (x2 >= 0 && x2 < source.width && y2 >= 0 && y2 < source.height) {
        int loc2 = x2 + y2 * source.width;
        r += matrix[row][col] * red(source.pixels[loc2]);
        g += matrix[row][col] * green(source.pixels[loc2]);
        b += matrix[row][col] * blue(source.pixels[loc2]);
      }
    }
  }
  return color(r,g,b);
}

