import processing.video.*;
Capture video;
int vidWidth = 320, vidHeight = 240;
color target = color(0,0,255);

void setup() {
  size(vidWidth, vidHeight);
  video = new Capture(this, vidWidth, vidHeight, 30);
}

void draw() {
  background(0);
  video.loadPixels();
  int bestPixelX = 0;
  int bestPixelY = 0;
  color pixel = video.pixels[0];
  float leastDistance = dist(red(target),green(target),blue(target),
                             red(pixel),green(pixel),blue(pixel));
  for(int x = 0; x < vidWidth; x++)
    for(int y = 0; y < vidHeight; y++) {
      int loc = x + y * width;
      pixel = video.pixels[loc];
      float distance = dist(red(target),green(target),blue(target),
                            red(pixel),green(pixel),blue(pixel));
      if (distance < leastDistance) {
        leastDistance = distance;
        bestPixelX = x;
        bestPixelY = y;
      }
    }
   fill(target);
   image(video,0,0);
   ellipse(bestPixelX, bestPixelY, 10, 10);
}

void captureEvent(Capture video) {
  video.read();
}

