class KinectTracker {
  int kw = 640;
  int kh = 480;
  PVector loc;
  int[] depth;

  KinectTracker() {
    kinect.start();
    kinect.enableDepth(true);
    kinect.processDepthImage(true);
    loc = new PVector(0,0);
  }

  void track() {
    depth = kinect.getRawDepth();
    int leastDepth = depth[0];
    int leastDepthIndex = 0;
    for (int i = 1; i < depth.length; i++)
      if (depth[i] < leastDepth) {
        leastDepth = depth[i];
        leastDepthIndex = i;
      }
    int x = leastDepthIndex % kw;
    int y = leastDepthIndex/kw;
    loc = new PVector(x,y);
  }

  PVector getPos() {
    return loc;
  }

  void quit() {
    kinect.quit();
  }

}

