import processing.video.*;

Capture video;
int vidWidth = 320, vidHeight = 240;

void setup() {
  size(vidWidth, vidHeight);
  video = new Capture(this, vidWidth, vidHeight, 30);
}

void draw() {
  background(0);
  video.loadPixels();
  int brightestPixelX = 0;
  int brightestPixelY = 0;
  float maxBrightness = brightness(video.pixels[0]);
  for(int x = 0; x < vidWidth; x++)
    for(int y = 0; y < vidHeight; y++) {
      int loc = x + y * width;
      float b = brightness(video.pixels[loc]);
      if (b > maxBrightness) {
        maxBrightness = b;
        brightestPixelX = x;
        brightestPixelY = y;
      }
    }
   fill(255,0,0);
   image(video,0,0);
   ellipse(brightestPixelX, brightestPixelY, 10, 10);

}

void captureEvent(Capture video) {
  video.read();
}

