int modulus = 36;
int[] pcset = {0,5,10,15,20,25,30};
int w = 800;
int originx = w/2;
int originy = w/2;
float radius = w * .3;
int pcRadius = min(20,w*8/(5*modulus));
int fontsize = (int)(pcRadius * .6);
float springSpacing = radius/(pcset.length*0.5);
float springOffset = springSpacing/(pcset.length+1);

void setup() {
  pcset = sort(pcset);
  PFont font;
  font = createFont("TimesNewRoman",fontsize); 
  textFont(font);
  textAlign(CENTER,CENTER);

  smooth();
  background(255);
  size(w,w);
  drawChromaticCircle();
  drawPCSet();

  drawSprings();
}


void drawChromaticCircle() {
  for(int i = 0; i < modulus; i++) {
    int x = originx+(int)(radius*Math.sin(i*TWO_PI/modulus));
    int y = originy-(int)(radius*Math.cos(i*TWO_PI/modulus));
    drawPCCircle(i,x,y,false);
    fill(0);
    text(i,x,y-.1*pcRadius);
  }
}

void drawPCCircle(int i, int x, int y, boolean occupied) {
  if (occupied) {
    stroke(0);
    line(originx,originy,x,y);
    fill(0);
  } 
  else
    noFill();
  stroke(0);
  ellipse(x,y,pcRadius,pcRadius);
  if (occupied) {
    fill(255);
    text(i,x,y-.1*pcRadius);
  }
}

void drawPCSet() {
  for(int i = 0; i < pcset.length; i++) {
    int x = originx+(int)(radius*Math.sin(pcset[i]*TWO_PI/modulus));
    int y = originy-(int)(radius*Math.cos(pcset[i]*TWO_PI/modulus));
    drawPCCircle(pcset[i],x,y,true);
  }
}

void drawSprings() {
  noFill();
  float unevenness = 0.0f;
  int unevennessNumerator = 0;

  int potDen = pcset.length * modulus;
  potDen *= potDen;  
  for (int i = 0; i < pcset.length - 1; i++) {
    for(int j = i + 1; j < pcset.length; j++) {
      int clockwiseFromI = pcset[j] - pcset[i];
      int clockwiseFromJ = pcset[i]+modulus - pcset[j];
      int clen = min(clockwiseFromI,clockwiseFromJ);
      int dlen = j - i;
      if (clockwiseFromJ < clockwiseFromI)
        dlen = i + pcset.length - j;
      int potNum = (clen * pcset.length) - (dlen * modulus);
      potNum *= potNum;
      float potential = 1.0*potNum/potDen;
      unevenness += potential;
      unevennessNumerator += potNum;
      float redComponent = constrain(5.0*potential * 255,0,255);
      float blueComponent = constrain(5.0*(1 - potential) * 255,0,255);
      stroke(redComponent, 0.0, blueComponent);
      float iAngle = (3 * PI/2) + pcset[i] * TWO_PI/modulus;
      if (iAngle > TWO_PI) iAngle -= TWO_PI;
      float jAngle = (3 * PI/2) + pcset[j] * TWO_PI/modulus;
      if (jAngle > TWO_PI) jAngle -= TWO_PI;
      float startAngle, stopAngle;
      if (clockwiseFromJ < clockwiseFromI) {
        startAngle = jAngle;
        stopAngle = iAngle;
      } 
      else {
        startAngle = iAngle;
        stopAngle = jAngle;
      }
      if (i == 0)
        arc((float)originx,(float)originy,dlen*springSpacing+(i*springOffset),dlen*springSpacing+(i*springOffset),startAngle,stopAngle);
    }
  }
  fill(0);
  String unevennessString = String.format("%.4f",unevenness);
  text("Unevenness = "+unevennessString+"\nNumerator = "+unevennessNumerator+"\n"+"Denominator = "+potDen,w/2,3*w/4+radius/2);
}



