/*
 * Decompiled with CFR 0.152.
 */
package jmetude;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import jm.music.data.Note;
import jm.music.data.Part;
import jm.music.data.Phrase;
import jm.music.data.Rest;
import jm.music.data.Score;
import jm.music.tools.Mod;
import jm.util.Play;
import jm.util.Read;
import jm.util.Write;
import jmetude.EtudeConst;
import processing.core.PApplet;

public class Etude
implements EtudeConst {
    Vector scores = new Vector();
    Vector parts = new Vector();
    Vector phrases = new Vector();
    PApplet parent;

    public Etude(PApplet p) {
        this.parent = p;
        this.parent.registerDispose((Object)this);
    }

    public void dispose() {
        this.stopMIDI();
    }

    public void createScore(String title) {
        Score s = new Score(title);
        s.setTempo(120.0);
        this.scores.add(s);
    }

    public void createScore(String title, String midiFile) {
        Score s = new Score(title);
        this.scores.add(s);
        if (midiFile.startsWith("http://")) {
            URL url = null;
            try {
                url = new URL(midiFile);
            }
            catch (MalformedURLException e) {
                this.handleException(e);
            }
            Read.midi((Score)s, (URL)url);
        } else {
            Read.midi((Score)s, (String)midiFile);
        }
        Vector tmpParts = s.getPartList();
        int i = 0;
        while (i < tmpParts.size()) {
            String partTitle = "part_" + i;
            Part tmpPart = (Part)tmpParts.get(i);
            tmpPart.setTitle(partTitle);
            this.parts.add(tmpPart);
            Vector tmpPhrases = tmpPart.getPhraseList();
            int j = 0;
            while (j < tmpPhrases.size()) {
                String phraseTitle = String.valueOf(partTitle) + "_phrase_" + j;
                Phrase tmpPhrase = (Phrase)tmpPhrases.get(j);
                tmpPhrase.setTitle(phraseTitle);
                this.phrases.add(tmpPhrase);
                ++j;
            }
            ++i;
        }
    }

    public void addScorePart(String scoreTitle, String partTitle) {
        Score s = null;
        Part p = null;
        try {
            s = this.getScore(scoreTitle);
            p = this.getPart(partTitle);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        s.addPart(p);
    }

    public String[] getScoreParts(String scoreTitle) {
        Score s = null;
        try {
            s = this.getScore(scoreTitle);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        Vector tmpParts = s.getPartList();
        String[] parts = new String[tmpParts.size()];
        int i = 0;
        while (i < tmpParts.size()) {
            Part tmp = (Part)tmpParts.get(i);
            parts[i] = tmp.getTitle();
            ++i;
        }
        return parts;
    }

    public void removeScorePart(String scoreTitle, String partTitle) {
        Score s = null;
        Part p = null;
        try {
            s = this.getScore(scoreTitle);
            p = this.getPart(partTitle);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        s.removePart(p);
    }

    public void createPart(String partTitle) {
        this.createPart(partTitle, 0, 0);
    }

    public void createPart(String partTitle, int instrument) {
        this.createPart(partTitle, instrument, 0);
    }

    public void createPart(String title, int instrument, int channel) {
        Part p = new Part(title, instrument, channel);
        p.setTempo(120.0);
        this.parts.add(p);
    }

    public void addPartPhrase(String partTitle, String phraseTitle) {
        Part p = null;
        Phrase ph = null;
        try {
            p = this.getPart(partTitle);
            ph = this.getPhrase(phraseTitle);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        p.addPhrase(ph);
    }

    public String[] getPartPhrases(String partTitle) {
        Part p = null;
        try {
            p = this.getPart(partTitle);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        Vector tmpPhrases = p.getPhraseList();
        String[] phrases = new String[tmpPhrases.size()];
        int i = 0;
        while (i < tmpPhrases.size()) {
            Phrase tmp = (Phrase)tmpPhrases.get(i);
            phrases[i] = tmp.getTitle();
            ++i;
        }
        return phrases;
    }

    public void removePartPhrase(String partTitle, String phraseTitle) {
        Part p = null;
        Phrase ph = null;
        try {
            p = this.getPart(partTitle);
            ph = this.getPhrase(phraseTitle);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        p.removePhrase(ph);
    }

    public void setPartInstrument(String partTitle, int instrument) {
        Part p = null;
        try {
            p = this.getPart(partTitle);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        p.setInstrument(instrument);
    }

    public int getPartInstrument(String partTitle) {
        Part p = null;
        try {
            p = this.getPart(partTitle);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return p.getInstrument();
    }

    public void setPartChannel(String partTitle, int channel) {
        Part p = null;
        try {
            p = this.getPart(partTitle);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        p.setChannel(channel);
    }

    public int getPartChannel(String partTitle) {
        Part p = null;
        try {
            p = this.getPart(partTitle);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return p.getChannel();
    }

    public void setPartPan(String partTitle, float pan) {
        Part p = null;
        try {
            p = this.getPart(partTitle);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        p.setPan((double)pan);
    }

    public float getPartPan(String partTitle) {
        Part p = null;
        try {
            p = this.getPart(partTitle);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return (float)p.getPan();
    }

    public void createPhrase(String phraseTitle) {
        float[][] notes = null;
        this.createPhrase(phraseTitle, notes);
    }

    public void createPhrase(String phraseTitle, float[] note) {
        float[][] notes = new float[1][2];
        notes[0] = note;
        this.createPhrase(phraseTitle, notes);
    }

    public void createPhrase(String phraseTitle, float[][] notes) {
        Phrase ph = new Phrase(phraseTitle, 0.0);
        ph.setTempo(120.0);
        this.phrases.add(ph);
        if (notes != null) {
            this.addPhraseNote(phraseTitle, notes);
        }
    }

    public void setPhraseStartTime(String phraseTitle, float startTime) {
        Phrase ph = null;
        try {
            ph = this.getPhrase(phraseTitle);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        ph.setStartTime((double)startTime);
    }

    public float getPhraseStartTime(String phraseTitle) {
        Phrase ph = null;
        try {
            ph = this.getPhrase(phraseTitle);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return (float)ph.getStartTime();
    }

    public void repeatPhrase(String phraseTitle, int num) {
        Phrase ph = null;
        try {
            ph = this.getPhrase(phraseTitle);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        Mod.repeat((Phrase)ph, (int)num);
    }

    public void addPhraseNote(String phraseTitle, float[] note) {
        Phrase ph = null;
        try {
            ph = this.getPhrase(phraseTitle);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if ((double)note[0] > 0.0) {
            ph.addNote((int)note[0], (double)note[1]);
        } else {
            ph.addRest(new Rest((double)note[1]));
        }
    }

    public void addPhraseNote(String phraseTitle, float[][] note) {
        int i = 0;
        while (i < note.length) {
            this.addPhraseNote(phraseTitle, note[i]);
            ++i;
        }
    }

    public void addPhraseNoteList(String phraseTitle, float[][] notes) {
        Phrase ph = null;
        try {
            ph = this.getPhrase(phraseTitle);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        int i = 0;
        while (i < notes.length) {
            this.addPhraseNote(phraseTitle, notes[i]);
            ++i;
        }
    }

    public float[][] getPhraseNotes(String phraseTitle) {
        Phrase ph = null;
        try {
            ph = this.getPhrase(phraseTitle);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        Vector tmp = ph.getNoteList();
        float[][] notes = new float[tmp.size()][2];
        int i = 0;
        while (i < tmp.size()) {
            Note n = (Note)tmp.get(i);
            notes[i][0] = n.getPitch() >= 0 ? (float)n.getPitch() : -1.0f;
            notes[i][1] = (float)n.getRhythmValue();
            ++i;
        }
        return notes;
    }

    public void setPhraseInstrument(String phraseTitle, int instrument) {
        Phrase ph = null;
        try {
            ph = this.getPhrase(phraseTitle);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        ph.setInstrument(instrument);
    }

    public int getPhraseInstrument(String phraseTitle) {
        Phrase ph = null;
        try {
            ph = this.getPhrase(phraseTitle);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return ph.getInstrument();
    }

    public void setVolume(String title, int volume) {
        Object o = null;
        try {
            o = this.getObjectByTitle(title);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (o instanceof Score) {
            Score s = (Score)o;
            s.setVolume(volume);
        } else if (o instanceof Part) {
            Part p = (Part)o;
            p.setVolume(volume);
        } else if (o instanceof Phrase) {
            Phrase ph = (Phrase)o;
            ph.setVolume(volume);
        }
    }

    public int getVolume(String title) {
        Object o = null;
        int volume = 0;
        try {
            o = this.getObjectByTitle(title);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (o instanceof Score) {
            Score s = (Score)o;
            volume = s.getVolume();
        } else if (o instanceof Part) {
            Part p = (Part)o;
            volume = p.getVolume();
        } else if (o instanceof Phrase) {
            Phrase ph = (Phrase)o;
            volume = ph.getVolume();
        }
        return volume;
    }

    public void setTempo(String title, float tempo) {
        Object o = null;
        try {
            o = this.getObjectByTitle(title);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (o instanceof Score) {
            Score s = (Score)o;
            s.setTempo((double)tempo);
        } else if (o instanceof Part) {
            Part p = (Part)o;
            p.setTempo((double)tempo);
        } else if (o instanceof Phrase) {
            Phrase ph = (Phrase)o;
            ph.setTempo((double)tempo);
        }
    }

    public float getTempo(String title) {
        Object o = null;
        float tempo = 0.0f;
        try {
            o = this.getObjectByTitle(title);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (o instanceof Score) {
            Score s = (Score)o;
            tempo = (float)s.getTempo();
        } else if (o instanceof Part) {
            Part p = (Part)o;
            tempo = (float)p.getTempo();
        } else if (o instanceof Phrase) {
            Phrase ph = (Phrase)o;
            tempo = (float)ph.getTempo();
        }
        return tempo;
    }

    public float getEndTime(String title) {
        Object o = null;
        float endTime = 0.0f;
        try {
            o = this.getObjectByTitle(title);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (o instanceof Score) {
            Score s = (Score)o;
            endTime = (float)s.getEndTime();
        } else if (o instanceof Part) {
            Part p = (Part)o;
            endTime = (float)p.getEndTime();
        } else if (o instanceof Phrase) {
            Phrase ph = (Phrase)o;
            endTime = (float)ph.getEndTime();
        }
        return endTime;
    }

    public void setTitle(String title, String newTitle) {
        Object o = null;
        try {
            o = this.getObjectByTitle(title);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (o instanceof Score) {
            Score s = (Score)o;
            s.setTitle(newTitle);
        } else if (o instanceof Part) {
            Part p = (Part)o;
            p.setTitle(newTitle);
        } else if (o instanceof Phrase) {
            Phrase ph = (Phrase)o;
            ph.setTitle(newTitle);
        }
    }

    public void transpose(String title, int transposition) {
        Object o = null;
        try {
            o = this.getObjectByTitle(title);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (o instanceof Score) {
            Score s = (Score)o;
            Mod.transpose((Score)s, (int)transposition);
        } else if (o instanceof Part) {
            Part p = (Part)o;
            Mod.transpose((Part)p, (int)transposition);
        } else if (o instanceof Phrase) {
            Phrase ph = (Phrase)o;
            Mod.transpose((Phrase)ph, (int)transposition);
        }
    }

    public void clear(String title) {
        Object o = null;
        try {
            o = this.getObjectByTitle(title);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (o instanceof Score) {
            Score s = (Score)o;
            s.empty();
        } else if (o instanceof Part) {
            Part p = (Part)o;
            p.empty();
        } else if (o instanceof Phrase) {
            Phrase ph = (Phrase)o;
            ph.empty();
        }
    }

    public void createMIDI(String title, String fileName) {
        Object o = null;
        try {
            o = this.getObjectByTitle(title);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (o instanceof Score) {
            Score s = (Score)o;
            Write.midi((Score)s, (String)fileName);
        } else if (o instanceof Part) {
            Part p = (Part)o;
            Write.midi((Part)p, (String)fileName);
        } else if (o instanceof Phrase) {
            Phrase ph = (Phrase)o;
            Write.midi((Phrase)ph, (String)fileName);
        }
    }

    public void playMIDI(String title) {
        Object o = null;
        try {
            o = this.getObjectByTitle(title);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (o instanceof Score) {
            Play.midi((Score)((Score)o), (boolean)false);
        } else if (o instanceof Part) {
            Play.midi((Part)((Part)o), (boolean)false);
        } else if (o instanceof Phrase) {
            Play.midi((Phrase)((Phrase)o), (boolean)false);
        }
    }

    public void stopMIDI() {
        Play.stopMidi();
    }

    private Score getScore(String title) throws Exception {
        int i = 0;
        while (i < this.scores.size()) {
            Score tmp = (Score)this.scores.get(i);
            if (tmp.getTitle().equals(title)) {
                return tmp;
            }
            ++i;
        }
        throw new Exception("Sorry, could not find score '" + title + " '");
    }

    private Part getPart(String title) throws Exception {
        int i = 0;
        while (i < this.parts.size()) {
            Part tmp = (Part)this.parts.get(i);
            if (tmp.getTitle().equals(title)) {
                return tmp;
            }
            ++i;
        }
        throw new Exception("Sorry, could not find part '" + title + " '");
    }

    private Phrase getPhrase(String title) throws Exception {
        int i = 0;
        while (i < this.phrases.size()) {
            Phrase tmp = (Phrase)this.phrases.get(i);
            if (tmp.getTitle().equals(title)) {
                return tmp;
            }
            ++i;
        }
        throw new Exception("Sorry, could not find part '" + title + " '");
    }

    private Object getObjectByTitle(String title) throws Exception {
        Phrase obj = null;
        try {
            obj = this.getPhrase(title);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            obj = this.getPart(title);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            obj = this.getScore(title);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (obj == null) {
            throw new Exception("Sorry, could not find any phrase, part or score with the title ' " + title + " '");
        }
        return obj;
    }

    private void handleException(Exception e) {
        this.parent.stop();
        e.printStackTrace();
        System.exit(0);
    }
}

