/*
 * Decompiled with CFR 0.152.
 */
package simpleML;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class A2ZXmlReader {
    private String urlPath;
    private Document doc;
    private Element root;

    public A2ZXmlReader(String name) throws IOException {
        this.urlPath = name;
        try {
            this.createDocument();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void createDocument() throws ParserConfigurationException, SAXException, IOException {
        InputStream is = this.openStream(this.urlPath);
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        this.doc = docBuilder.parse(is);
        this.doc.getDocumentElement().normalize();
        this.root = this.doc.getDocumentElement();
    }

    public Element getRoot() {
        return this.root;
    }

    public void traverseXML(Node currNode) {
        int i;
        if (currNode.getNodeType() == 1) {
            System.out.print(String.valueOf(currNode.getNodeName()) + ": ");
        } else if (currNode.getNodeType() == 3) {
            System.out.println(currNode.getNodeValue().trim());
        }
        if (currNode.hasAttributes()) {
            NamedNodeMap attributes = currNode.getAttributes();
            i = 0;
            while (i < attributes.getLength()) {
                Node attr = attributes.item(i);
                System.out.println("  " + attr.getNodeName() + ": " + attr.getNodeValue());
                ++i;
            }
        }
        if (currNode.hasChildNodes()) {
            NodeList children = currNode.getChildNodes();
            i = 0;
            while (i < children.getLength()) {
                Node n = children.item(i);
                this.traverseXML(n);
                ++i;
            }
        }
    }

    public Element findElement(Element currElement, String elementName) {
        Element found = null;
        if (currElement.getTagName().equals(elementName)) {
            found = currElement;
        } else if (currElement.hasChildNodes()) {
            NodeList children = currElement.getChildNodes();
            int i = 0;
            while (i < children.getLength() && found == null) {
                Node n = children.item(i);
                if (n.getNodeType() == 1) {
                    Element e = (Element)n;
                    found = this.findElement(e, elementName);
                }
                ++i;
            }
        }
        return found;
    }

    public void fillArrayList(Element currElement, String elementName, ArrayList a) {
        Element found = null;
        if (currElement.getTagName().equals(elementName)) {
            found = currElement;
        } else if (currElement.hasChildNodes()) {
            NodeList children = currElement.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node n = children.item(i);
                if (n.getNodeType() == 1) {
                    Element e = (Element)n;
                    this.fillArrayList(e, elementName, a);
                }
                ++i;
            }
        }
        if (found != null) {
            a.add(found);
        }
    }

    private InputStream openStream(String urlpath) {
        InputStream stream = null;
        try {
            URL url = new URL(urlpath);
            stream = url.openStream();
            return stream;
        }
        catch (MalformedURLException e) {
            System.out.println("Something's wrong with the URL:  " + urlpath);
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println("there's a problem downloading from:  " + urlpath);
            e.printStackTrace();
        }
        return stream;
    }
}

