/*
 * Decompiled with CFR 0.152.
 */
package pyahoo;

import com.yahoo.search.SearchClient;
import com.yahoo.search.SearchException;
import com.yahoo.search.WebSearchRequest;
import com.yahoo.search.WebSearchResult;
import com.yahoo.search.WebSearchResults;
import java.io.IOException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import processing.core.PApplet;

public class YahooSearch
implements Runnable {
    PApplet parent;
    String key;
    Method eventMethod;
    Thread runner;
    boolean available = false;
    String searchString;
    int numRequested = 10;
    SearchClient client;
    WebSearchResults results;
    boolean searching = false;

    public YahooSearch(PApplet parent, String key) {
        this.client = new SearchClient(key);
        this.results = null;
        this.parent = parent;
        this.key = key;
        parent.registerDispose((Object)this);
        try {
            this.eventMethod = parent.getClass().getMethod("searchEvent", YahooSearch.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void search(String searchString_) {
        this.search(searchString_, 10);
    }

    public void search(String searchString_, int num) {
        if (!this.searching) {
            this.searching = true;
            this.numRequested = num;
            this.searchString = searchString_;
            this.runner = new Thread(this);
            this.runner.start();
        } else {
            YahooSearch ys = new YahooSearch(this.parent, this.key);
            ys.search(searchString_, num);
        }
    }

    public boolean available() {
        return this.available;
    }

    public WebSearchResults getResults() {
        return this.results;
    }

    public String[] getTitles() {
        if (this.results == null) {
            return null;
        }
        WebSearchResult[] resultsArray = this.results.listResults();
        String[] titles = new String[resultsArray.length];
        int i = 0;
        while (i < titles.length) {
            titles[i] = resultsArray[i].getTitle();
            ++i;
        }
        return titles;
    }

    public String[] getUrls() {
        if (this.results == null) {
            return null;
        }
        WebSearchResult[] resultsArray = this.results.listResults();
        String[] urls = new String[resultsArray.length];
        int i = 0;
        while (i < urls.length) {
            urls[i] = resultsArray[i].getUrl();
            ++i;
        }
        return urls;
    }

    public String[] getSummaries() {
        if (this.results == null) {
            return null;
        }
        WebSearchResult[] resultsArray = this.results.listResults();
        String[] summaries = new String[resultsArray.length];
        int i = 0;
        while (i < summaries.length) {
            summaries[i] = resultsArray[i].getSummary();
            ++i;
        }
        return summaries;
    }

    public WebSearchResult[] getResultsArray() {
        if (this.results == null) {
            return null;
        }
        return this.results.listResults();
    }

    public int getTotalResultsAvailable() {
        int total = 0;
        if (this.results != null) {
            BigInteger count = this.results.getTotalResultsAvailable();
            total = count.intValue();
        }
        return total;
    }

    public void run() {
        try {
            this.available = false;
            WebSearchRequest request = new WebSearchRequest(this.searchString);
            System.out.println("Searching for " + this.searchString);
            request.setResults(this.numRequested);
            this.results = this.client.webSearch(request);
            this.available = true;
            if (this.eventMethod != null) {
                try {
                    this.eventMethod.invoke((Object)this.parent, this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.eventMethod = null;
                }
            }
            this.searching = false;
        }
        catch (IOException e) {
            System.out.println("Error calling Yahoo! Search Service: " + e.toString());
            e.printStackTrace();
        }
        catch (SearchException e) {
            System.out.println("Error calling Yahoo! Search Service: " + e.toString());
            e.printStackTrace();
        }
    }

    public void stop() {
        this.runner = null;
    }

    public void dispose() {
        this.stop();
    }

    public String getSearchString() {
        return this.searchString;
    }

    public int getNumberRequested() {
        return this.numRequested;
    }
}

