/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.xml;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlParser
extends DefaultHandler {
    private Stack stack;
    private Map root = null;
    private Stack typeStack;

    public static final Object get(Map map, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring(1), "/");
        Map map2 = map;
        while (map2 != null && stringTokenizer.hasMoreTokens()) {
            if (map2 == null) continue;
            map2 = map2.get(stringTokenizer.nextToken());
        }
        return map2;
    }

    public static String getString(Map map, String string) {
        return (String)XmlParser.get(map, string);
    }

    public static List getList(Map map, String string) {
        ArrayList arrayList = XmlParser.get(map, string);
        if (arrayList != null && !(arrayList instanceof List)) {
            ArrayList arrayList2 = new ArrayList();
            arrayList2.add(arrayList);
            arrayList = arrayList2;
        }
        return arrayList;
    }

    public static BigInteger getBigInteger(Map map, String string) {
        String string2 = XmlParser.getString(map, string);
        return string2 != null ? new BigInteger(string2, 10) : null;
    }

    public static BigDecimal getBigDecimal(Map map, String string) {
        String string2 = XmlParser.getString(map, string);
        if (string2.equalsIgnoreCase("NaN")) {
            string2 = null;
        }
        return string2 != null ? new BigDecimal(string2) : null;
    }

    public static Boolean getBoolean(Map map, String string) {
        String string2 = XmlParser.getString(map, string);
        return string2 != null ? Boolean.valueOf(string2) : null;
    }

    public void startDocument() throws SAXException {
        this.stack = new Stack();
        this.stack.push(new HashMap());
        this.typeStack = new Stack();
    }

    public void endDocument() throws SAXException {
        if (this.stack.size() != 1) {
            throw new SAXException("Parse error, stack size greater than 1");
        }
        this.root = (Map)this.stack.pop();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = this.typeStack.size() > 0 ? (String)this.typeStack.peek() : "";
        this.typeStack.push(string4 + "/" + string3);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            hashMap.put(attributes.getQName(i), attributes.getValue(i));
        }
        Map map = (Map)this.stack.peek();
        Object v = map.get(string3);
        if (v == null) {
            map.put(string3, hashMap);
        } else if (v instanceof Map) {
            LinkedList<Object> linkedList = new LinkedList<Object>();
            linkedList.add(v);
            linkedList.add(hashMap);
            map.put(string3, linkedList);
        } else if (v instanceof List) {
            ((List)v).add(hashMap);
        }
        this.stack.push(hashMap);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.stack.pop();
        this.typeStack.pop();
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = (String)((Map)this.stack.peek()).get("value");
        string = string != null ? string + new String(cArray, n, n2) : new String(cArray, n, n2);
        ((Map)this.stack.peek()).put("value", string);
    }

    public Map getRoot() {
        return this.root;
    }
}

