/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.shopping.xmlparser;

import com.yahoo.shopping.CatalogListingResults;
import com.yahoo.shopping.CatalogOffer;
import com.yahoo.shopping.Condition;
import com.yahoo.shopping.Cost;
import com.yahoo.shopping.Merchant;
import com.yahoo.xml.XmlParser;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;

public class XmlParserCatalogListingResults
implements CatalogListingResults {
    private Map root;
    private CatalogOffer[] results;

    public XmlParserCatalogListingResults(Map map) {
        this.root = map;
        List list = XmlParser.getList(map, "/CatalogListing/Offer");
        if (list != null) {
            this.results = new CatalogOffer[list.size()];
            for (int i = 0; i < this.results.length; ++i) {
                Map map2 = (Map)list.get(i);
                this.results[i] = new XmlParserCatalogOffer(map2);
            }
        } else {
            this.results = new CatalogOffer[0];
        }
    }

    public BigInteger getId() {
        return XmlParser.getBigInteger(this.root, "/CatalogListing/ID");
    }

    public BigInteger getNumberOfOffers() {
        return XmlParser.getBigInteger(this.root, "/CatalogListing/numOffers");
    }

    public String getZipCode() {
        return XmlParser.getString(this.root, "/CatalogListing/zip");
    }

    public CatalogOffer[] listOffers() {
        return this.results;
    }

    private class XmlParserCatalogOffer
    implements CatalogOffer {
        private Map offer;

        public XmlParserCatalogOffer(Map map) {
            this.offer = map;
        }

        public Merchant getMerchant() {
            return null;
        }

        public String getUrl() {
            return XmlParser.getString(XmlParserCatalogListingResults.this.root, "/Url/value");
        }

        public Condition getCondition() {
            return null;
        }

        public Cost getTaxCost() {
            return null;
        }

        public Cost getShippingCost() {
            return null;
        }

        public BigDecimal getBasePrice() {
            return XmlParser.getBigDecimal(XmlParserCatalogListingResults.this.root, "/BasePrice/value");
        }

        public BigDecimal getTotalPrice() {
            return XmlParser.getBigDecimal(XmlParserCatalogListingResults.this.root, "/TotalPrice/value");
        }

        public BigDecimal getStrikethroughPrice() {
            return XmlParser.getBigDecimal(XmlParserCatalogListingResults.this.root, "/StrikeThroughPrice/value");
        }
    }
}

