/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.xmlparser;

import com.yahoo.search.ImageThumbnail;
import com.yahoo.search.NewsSearchResult;
import com.yahoo.search.NewsSearchResults;
import com.yahoo.search.xmlparser.XmlParserImageThumbnail;
import com.yahoo.xml.XmlParser;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;

public class XmlParserNewsSearchResults
implements NewsSearchResults {
    private Map root;
    private NewsSearchResult[] results;

    public XmlParserNewsSearchResults(Map map) {
        this.root = map;
        List list = XmlParser.getList(map, "/ResultSet/Result");
        if (list != null) {
            this.results = new NewsSearchResult[list.size()];
            for (int i = 0; i < this.results.length; ++i) {
                Map map2 = (Map)list.get(i);
                this.results[i] = new XmlParserNewsSearchResult(map2);
            }
        } else {
            this.results = new NewsSearchResult[0];
        }
    }

    public BigInteger getTotalResultsAvailable() {
        return XmlParser.getBigInteger(this.root, "/ResultSet/totalResultsAvailable");
    }

    public BigInteger getTotalResultsReturned() {
        return XmlParser.getBigInteger(this.root, "/ResultSet/totalResultsReturned");
    }

    public BigInteger getFirstResultPosition() {
        return XmlParser.getBigInteger(this.root, "/ResultSet/firstResultPosition");
    }

    public NewsSearchResult[] listResults() {
        return this.results;
    }

    private class XmlParserNewsSearchResult
    implements NewsSearchResult {
        private Map result;
        private ImageThumbnail thumbnail;

        public XmlParserNewsSearchResult(Map map) {
            this.result = map;
            Map map2 = (Map)map.get("Thumbnail");
            if (map2 != null) {
                this.thumbnail = new XmlParserImageThumbnail(map2);
            }
        }

        public String getTitle() {
            return XmlParser.getString(this.result, "/Title/value");
        }

        public String getSummary() {
            return XmlParser.getString(this.result, "/Summary/value");
        }

        public String getUrl() {
            return XmlParser.getString(this.result, "/Url/value");
        }

        public String getClickUrl() {
            return XmlParser.getString(this.result, "/ClickUrl/value");
        }

        public String getNewsSource() {
            return XmlParser.getString(this.result, "/NewsSource/value");
        }

        public String getNewsSourceUrl() {
            return XmlParser.getString(this.result, "/NewsSourceUrl/value");
        }

        public String getLanguage() {
            return XmlParser.getString(this.result, "/Language/value");
        }

        public String getPublishDate() {
            return XmlParser.getString(this.result, "/PublishDate/value");
        }

        public String getModificationDate() {
            return XmlParser.getString(this.result, "/ModificationDate/value");
        }

        public ImageThumbnail getThumbnail() {
            return this.thumbnail;
        }
    }
}

