/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.myweb2.xmlparser;

import com.yahoo.myweb2.UrlSearchResult;
import com.yahoo.myweb2.UrlSearchResults;
import com.yahoo.xml.XmlParser;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;

public class XmlParserUrlSearchResults
implements UrlSearchResults {
    private Map root;
    private UrlSearchResult[] results;

    public XmlParserUrlSearchResults(Map map) {
        this.root = map;
        List list = XmlParser.getList(map, "/ResultSet/Result");
        if (list != null) {
            this.results = new UrlSearchResult[list.size()];
            for (int i = 0; i < this.results.length; ++i) {
                Map map2 = (Map)list.get(i);
                this.results[i] = new XmlParserUrlSearchResult(map2);
            }
        } else {
            this.results = new UrlSearchResult[0];
        }
    }

    public BigInteger getTotalResultsAvailable() {
        return XmlParser.getBigInteger(this.root, "/ResultSet/totalResultsAvailable");
    }

    public BigInteger getTotalResultsReturned() {
        return XmlParser.getBigInteger(this.root, "/ResultSet/totalResultsReturned");
    }

    public BigInteger getFirstResultPosition() {
        return XmlParser.getBigInteger(this.root, "/ResultSet/firstResultPosition");
    }

    public UrlSearchResult[] listResults() {
        return this.results;
    }

    private class XmlParserUrlSearchResult
    implements UrlSearchResult {
        private Map result;

        public XmlParserUrlSearchResult(Map map) {
            this.result = map;
        }

        public String getTitle() {
            return XmlParser.getString(this.result, "/Title/value");
        }

        public String getSummary() {
            return XmlParser.getString(this.result, "/Summary/value");
        }

        public String getUrl() {
            return XmlParser.getString(this.result, "/Url/value");
        }

        public String getClickUrl() {
            return XmlParser.getString(this.result, "/ClickUrl/value");
        }

        public String getUser() {
            return XmlParser.getString(this.result, "/User/value");
        }

        public String getNote() {
            return XmlParser.getString(this.result, "/Note/value");
        }

        public BigInteger getDate() {
            return XmlParser.getBigInteger(this.result, "/Date/value");
        }

        public String[] listTags() {
            return XmlParser.getList(this.result, "/Tags").toArray(new String[XmlParser.getList(this.result, "/Tags").size()]);
        }
    }
}

