/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.myweb2;

import com.yahoo.java.ExtendedError;
import com.yahoo.myweb2.MyWeb2Exception;
import com.yahoo.myweb2.RelatedTagsRequest;
import com.yahoo.myweb2.RelatedTagsResults;
import com.yahoo.myweb2.TagSearchRequest;
import com.yahoo.myweb2.TagSearchResults;
import com.yahoo.myweb2.UrlSearchRequest;
import com.yahoo.myweb2.UrlSearchResults;
import com.yahoo.myweb2.xmlparser.XmlParserRelatedTagsResults;
import com.yahoo.myweb2.xmlparser.XmlParserTagSearchResults;
import com.yahoo.myweb2.xmlparser.XmlParserUrlSearchResults;
import com.yahoo.rest.RestClient;
import com.yahoo.rest.RestException;
import com.yahoo.xml.XmlParser;
import java.io.IOException;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MyWeb2Client {
    private static final String APPID_KEY = "appid";
    private String appId;

    public MyWeb2Client(String string) {
        this.appId = string;
    }

    public UrlSearchResults urlSearch(UrlSearchRequest urlSearchRequest) throws IOException, MyWeb2Exception {
        urlSearchRequest.getParameters().put(APPID_KEY, this.appId);
        Map map = this.executeAndParse(urlSearchRequest.getRequestUrl(), urlSearchRequest.getParameters());
        return new XmlParserUrlSearchResults(map);
    }

    public TagSearchResults tagSearch(TagSearchRequest tagSearchRequest) throws IOException, MyWeb2Exception {
        tagSearchRequest.getParameters().put(APPID_KEY, this.appId);
        Map map = this.executeAndParse(tagSearchRequest.getRequestUrl(), tagSearchRequest.getParameters());
        return new XmlParserTagSearchResults(map);
    }

    public RelatedTagsResults relatedTags(RelatedTagsRequest relatedTagsRequest) throws IOException, MyWeb2Exception {
        relatedTagsRequest.getParameters().put(APPID_KEY, this.appId);
        Map map = this.executeAndParse(relatedTagsRequest.getRequestUrl(), relatedTagsRequest.getParameters());
        return new XmlParserRelatedTagsResults(map);
    }

    private Map executeAndParse(String string, Map map) throws IOException, MyWeb2Exception {
        XmlParser xmlParser = null;
        try {
            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
            xmlParser = new XmlParser();
            sAXParser.parse(RestClient.call(string, map), (DefaultHandler)xmlParser);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ExtendedError("XML parser not properly configured", parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new MyWeb2Exception("Error parsing XML response", sAXException);
        }
        catch (RestException restException) {
            throw new MyWeb2Exception("Error calling service\n" + new String(restException.getErrorMessage(), "UTF-8"), restException);
        }
        return xmlParser.getRoot();
    }
}

