/*
 * Decompiled with CFR 0.152.
 */
package s373.flob;

import java.util.ArrayList;
import processing.core.PApplet;
import processing.core.PImage;
import s373.flob.ABlob;
import s373.flob.Flob;
import s373.flob.pt2;
import s373.flob.quadBlob;
import s373.flob.trackedBlob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageBlobs {
    public int idnumbers = 0;
    public int numblobs;
    public int prevnumblobs;
    public int trackednumblobs;
    public int prevtrackednumblobs;
    public int lifetime = 100;
    public int ninpix = 100;
    public int maxpix = 10000;
    public boolean[] imagemap = null;
    public boolean imagemaplit = false;
    public int w;
    public int h;
    public float wr;
    public float hr;
    public float wcoordsx;
    public float wcoordsy;
    public int worldw = 700;
    public int worldh = 700;
    public int numpix;
    public float lp1 = 0.05f;
    public float lp2 = 1.0f - this.lp1;
    public float trackingmindist = 500.0f;
    public ArrayList<ABlob> theblobs = null;
    public ArrayList<ABlob> prevblobs = null;
    public ArrayList<trackedBlob> trackedblobs = null;
    public ArrayList<trackedBlob> prevtrackedblobs = null;
    public ArrayList<trackedBlob> tbsimplelist = null;
    public ArrayList<quadBlob> quadblobslist = null;
    public ArrayList<pt2> thecoords = null;
    private Flob tflob;

    ImageBlobs() {
        this.trackedblobs = new ArrayList();
        this.prevtrackedblobs = new ArrayList();
        this.theblobs = new ArrayList();
        this.prevblobs = new ArrayList();
        this.thecoords = new ArrayList();
        this.tbsimplelist = new ArrayList();
        this.quadblobslist = new ArrayList();
        this.prevnumblobs = 0;
        this.numblobs = 0;
        this.prevtrackednumblobs = 0;
        this.trackednumblobs = 0;
    }

    ImageBlobs(int w, int h, int ww, int wh) {
        this.trackedblobs = new ArrayList();
        this.prevtrackedblobs = new ArrayList();
        this.theblobs = new ArrayList();
        this.prevblobs = new ArrayList();
        this.thecoords = new ArrayList();
        this.tbsimplelist = new ArrayList();
        this.quadblobslist = new ArrayList();
        this.prevnumblobs = 0;
        this.numblobs = 0;
        this.prevtrackednumblobs = 0;
        this.trackednumblobs = 0;
        this.calcdims(w, h, ww, wh);
        this.worldw = ww;
        this.worldh = wh;
    }

    ImageBlobs(Flob flob) {
        this.tflob = flob;
        this.trackedblobs = new ArrayList();
        this.prevtrackedblobs = new ArrayList();
        this.theblobs = new ArrayList();
        this.prevblobs = new ArrayList();
        this.thecoords = new ArrayList();
        this.tbsimplelist = new ArrayList();
        this.quadblobslist = new ArrayList();
        this.prevnumblobs = 0;
        this.numblobs = 0;
        this.prevtrackednumblobs = 0;
        this.trackednumblobs = 0;
        this.calcdims(this.tflob.videoresw, this.tflob.videoresh, this.tflob.worldwidth, this.tflob.worldheight);
    }

    void calcdims(int w, int h, int ww, int wh) {
        this.w = w;
        this.h = h;
        this.wr = 1.0f / (float)w;
        this.hr = 1.0f / (float)h;
        this.numpix = w * h;
        this.worldw = ww;
        this.worldh = wh;
        this.wcoordsx = (float)this.worldw * this.wr;
        this.wcoordsy = (float)this.worldh * this.hr;
    }

    void setninpix(int nin) {
        this.ninpix = nin;
    }

    void setmaxpix(int max) {
        this.maxpix = max;
    }

    void setSmoothib(float f) {
        this.lp1 = f;
        this.lp2 = 1.0f - this.lp1;
    }

    ArrayList<ABlob> getblobsAL() {
        return this.theblobs;
    }

    void query() {
        System.out.print("query blobdata\n");
        System.out.print("numblobs " + this.numblobs + "\n");
        int i = 0;
        while (i < this.theblobs.size()) {
            ABlob b = this.theblobs.get(i);
            System.out.print("blob" + b.id + " pix" + b.pixelcount + " coords " + b.boxminx + " " + b.boxminy + " " + b.boxmaxx + " " + b.boxmaxy + "  center " + b.boxcenterx + " " + b.boxcentery + "\n");
            ++i;
        }
    }

    void calc(PImage pimage) {
        int min0 = 10000;
        int max0 = -100;
        pt2 p = new pt2();
        pt2 p2 = new pt2();
        int pixelcount = 0;
        ABlob b = new ABlob();
        this.copy_blobs_to_previousblobs();
        this.thecoords.clear();
        this.imagemap = new boolean[this.numpix];
        pimage.loadPixels();
        int j = 0;
        while (j < pimage.height) {
            int rowLoc = j * pimage.width;
            int i = 0;
            while (i < pimage.width) {
                if ((pimage.pixels[rowLoc + i] & 0xFF) > 0) {
                    if (i < min0) {
                        min0 = i;
                    } else if (i > max0) {
                        max0 = i;
                    }
                    if (!this.imagemap[rowLoc + i]) {
                        p.x = i;
                        p.y = j;
                        this.thecoords.add(p);
                        pixelcount = 0;
                        b.boxminx = i;
                        b.boxmaxx = i;
                        b.boxminy = j;
                        b.boxmaxy = j;
                        while (!this.thecoords.isEmpty()) {
                            int pixval2;
                            p2 = this.thecoords.remove(0);
                            if (p2.x < 0 || p2.x >= pimage.width || p2.y < 0 || p2.y >= pimage.height || this.imagemap[p2.y * pimage.width + p2.x] || (pixval2 = pimage.pixels[p2.y * pimage.width + p2.x] & 0xFF) <= 0) continue;
                            this.imagemap[p2.y * pimage.width + p2.x] = true;
                            ++pixelcount;
                            p = new pt2(p2.x, p2.y + 1);
                            this.thecoords.add(p);
                            p = new pt2(p2.x, p2.y - 1);
                            this.thecoords.add(p);
                            p = new pt2(p2.x + 1, p2.y);
                            this.thecoords.add(p);
                            p = new pt2(p2.x - 1, p2.y);
                            this.thecoords.add(p);
                            if (p2.x < b.boxminx) {
                                b.boxminx = p2.x;
                            }
                            if (p2.x > b.boxmaxx) {
                                b.boxmaxx = p2.x;
                            }
                            if (p2.y < b.boxminy) {
                                b.boxminy = p2.y;
                            }
                            if (p2.y <= b.boxmaxy) continue;
                            b.boxmaxy = p2.y;
                        }
                        if (pixelcount >= this.ninpix && pixelcount <= this.maxpix) {
                            b.id = this.numblobs;
                            b.pixelcount = pixelcount;
                            b.boxcenterx = (int)((double)(b.boxminx + b.boxmaxx) * 0.5);
                            b.boxcentery = (int)((double)(b.boxminy + b.boxmaxy) * 0.5);
                            b.boxdimx = b.boxmaxx - b.boxminx;
                            b.boxdimy = b.boxmaxy - b.boxminy;
                            b.cx = (float)b.boxcenterx * this.wcoordsx;
                            b.cy = (float)b.boxcentery * this.wcoordsy;
                            b.dimx = (float)(b.boxmaxx - b.boxminx) * this.wcoordsx;
                            b.dimy = (float)(b.boxmaxy - b.boxminy) * this.wcoordsy;
                            if (this.tflob.getAnyFeatureActive()) {
                                if (this.tflob.trackfeatures[0]) {
                                    b = this.calc_feature_head(b);
                                }
                                if (this.tflob.trackfeatures[1]) {
                                    b = this.calc_feature_arms(b);
                                }
                                if (this.tflob.trackfeatures[2]) {
                                    b = this.calc_feature_feet(b);
                                }
                                if (this.tflob.trackfeatures[3]) {
                                    b = this.calc_feature_bottom(b);
                                }
                            }
                            ABlob blob = new ABlob(b);
                            this.theblobs.add(blob);
                            ++this.numblobs;
                        }
                    }
                }
                ++i;
            }
            ++j;
        }
    }

    void calcQuad(PImage pimage) {
        int min0 = 10000;
        int max0 = -100;
        pt2 p = new pt2();
        pt2 p2 = new pt2();
        int pixelcount = 0;
        quadBlob b = new quadBlob();
        this.quadblobslist.clear();
        this.numblobs = 0;
        this.imagemap = new boolean[this.numpix];
        pimage.loadPixels();
        int j = 0;
        while (j < pimage.height) {
            int rowLoc = j * pimage.width;
            int i = 0;
            while (i < pimage.width) {
                if ((pimage.pixels[rowLoc + i] & 0xFF) > 0) {
                    if (i < min0) {
                        min0 = i;
                    } else if (i > max0) {
                        max0 = i;
                    }
                    if (!this.imagemap[rowLoc + i]) {
                        p.x = i;
                        p.y = j;
                        this.thecoords.add(p);
                        pixelcount = 0;
                        b.boxminx = i;
                        b.boxmaxx = i;
                        b.boxminy = j;
                        b.boxmaxy = j;
                        while (!this.thecoords.isEmpty()) {
                            int pixval2;
                            p2 = this.thecoords.remove(0);
                            if (p2.x < 0 || p2.x >= pimage.width || p2.y < 0 || p2.y >= pimage.height || this.imagemap[p2.y * pimage.width + p2.x] || (pixval2 = pimage.pixels[p2.y * pimage.width + p2.x] & 0xFF) <= 0) continue;
                            this.imagemap[p2.y * pimage.width + p2.x] = true;
                            ++pixelcount;
                            p = new pt2(p2.x, p2.y + 1);
                            this.thecoords.add(p);
                            p = new pt2(p2.x, p2.y - 1);
                            this.thecoords.add(p);
                            p = new pt2(p2.x + 1, p2.y);
                            this.thecoords.add(p);
                            p = new pt2(p2.x - 1, p2.y);
                            this.thecoords.add(p);
                            if (p2.x < b.boxminx) {
                                b.boxminx = p2.x;
                            }
                            if (p2.x > b.boxmaxx) {
                                b.boxmaxx = p2.x;
                            }
                            if (p2.y < b.boxminy) {
                                b.boxminy = p2.y;
                            }
                            if (p2.y <= b.boxmaxy) continue;
                            b.boxmaxy = p2.y;
                        }
                        if (pixelcount >= this.ninpix && pixelcount <= this.maxpix) {
                            b.id = this.numblobs++;
                            b.pixelcount = pixelcount;
                            b.boxcenterx = (int)((double)(b.boxminx + b.boxmaxx) * 0.5);
                            b.boxcentery = (int)((double)(b.boxminy + b.boxmaxy) * 0.5);
                            b.cx = (float)b.boxcenterx * this.wcoordsx;
                            b.cy = (float)b.boxcentery * this.wcoordsy;
                            b = this.calc_quad(b);
                            quadBlob blob = new quadBlob(b);
                            this.quadblobslist.add(blob);
                        }
                    }
                }
                ++i;
            }
            ++j;
        }
    }

    boolean testimagemap(int x, int y) {
        return this.imagemap[y * this.w + x];
    }

    ABlob calc_feature_arms(ABlob b) {
        int bx = b.boxminx;
        int by = b.boxminy;
        int ex = b.boxmaxx;
        int ey = b.boxmaxy;
        int cx = b.boxcenterx;
        int i = 0;
        int j = 0;
        boolean found = false;
        i = bx;
        j = by;
        while (j < ey) {
            if (this.testimagemap(i, j)) {
                b.armleftx = (float)i * this.wcoordsx;
                b.armlefty = (float)j * this.wcoordsy;
                found = true;
                break;
            }
            ++j;
        }
        if (!found) {
            j = by;
            i = bx;
            while (i < cx) {
                if (this.testimagemap(i, j)) {
                    b.armleftx = (float)i * this.wcoordsx;
                    b.armlefty = (float)j * this.wcoordsy;
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                b.armleftx = (float)b.boxcenterx * this.wcoordsx;
                b.armlefty = (float)b.boxcentery * this.wcoordsy;
            }
        }
        found = false;
        i = ex;
        j = by;
        while (j < ey) {
            if (this.testimagemap(i, j)) {
                b.armrightx = (float)i * this.wcoordsx;
                b.armrighty = (float)j * this.wcoordsy;
                found = true;
                break;
            }
            ++j;
        }
        if (!found) {
            j = by;
            i = ex - 1;
            while (i > cx) {
                if (this.testimagemap(i, j)) {
                    b.armrightx = (float)i * this.wcoordsx;
                    b.armrighty = (float)j * this.wcoordsy;
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                b.armrightx = (float)b.boxcenterx * this.wcoordsx;
                b.armrighty = (float)b.boxcentery * this.wcoordsy;
            }
        }
        return b;
    }

    ABlob calc_feature_head(ABlob b) {
        int by = b.boxminy;
        int ex = b.boxmaxx;
        int cx = b.boxcenterx;
        int i = 0;
        int j = 0;
        int k = cx - 1;
        j = by;
        i = cx;
        while (i < ex) {
            if (this.testimagemap(i, j)) {
                b.headx = (float)i * this.wcoordsx;
                b.heady = (float)j * this.wcoordsy;
                break;
            }
            if (this.testimagemap(k--, j)) {
                b.headx = (float)i * this.wcoordsx;
                b.heady = (float)j * this.wcoordsy;
                break;
            }
            ++i;
        }
        return b;
    }

    ABlob calc_feature_feet(ABlob b) {
        int bx = PApplet.constrain((int)b.boxminx, (int)0, (int)(this.w - 1));
        int ex = PApplet.constrain((int)b.boxmaxx, (int)0, (int)(this.w - 1));
        int ey = PApplet.constrain((int)b.boxmaxy, (int)0, (int)(this.h - 1));
        int cx = b.boxcenterx;
        int cy = b.boxcentery;
        cx = PApplet.constrain((int)cx, (int)0, (int)(this.w - 1));
        cy = PApplet.constrain((int)cy, (int)0, (int)(this.h - 1));
        int i = 0;
        int j = 0;
        j = ey;
        i = bx;
        while (i < cx) {
            if (this.testimagemap(i, j)) {
                b.footleftx = (float)i * this.wcoordsx;
                b.footlefty = (float)j * this.wcoordsx;
                break;
            }
            ++i;
        }
        j = ey;
        i = ex - 1;
        while (i > cx) {
            if (this.testimagemap(i, j)) {
                b.footrightx = (float)i * this.wcoordsx;
                b.footrighty = (float)j * this.wcoordsy;
                break;
            }
            --i;
        }
        return b;
    }

    ABlob calc_feature_bottom(ABlob b) {
        int ex = b.boxmaxx;
        int ey = b.boxmaxy;
        int cx = b.boxcenterx;
        int i = 0;
        int j = 0;
        boolean found = false;
        j = ey;
        i = cx;
        while (i < ex) {
            if (this.testimagemap(i, j)) {
                b.bottomx = (float)i * this.wcoordsx;
                b.bottomy = (float)j * this.wcoordsy;
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            i = 0;
            while (i <= cx) {
                if (this.testimagemap(i, j)) {
                    b.bottomx = (float)i * this.wcoordsx;
                    b.bottomy = (float)j * this.wcoordsy;
                    found = true;
                    break;
                }
                ++i;
            }
        }
        if (!found) {
            b.bottomx = (float)b.boxcenterx * this.wcoordsx;
            b.bottomy = (float)ey * this.wcoordsy;
        }
        return b;
    }

    quadBlob calc_quad(quadBlob b) {
        int bx = b.boxminx;
        int by = b.boxminy;
        int ex = b.boxmaxx;
        int ey = b.boxmaxy;
        int cx = b.boxcenterx;
        int i = 0;
        int j = 0;
        boolean found = false;
        i = bx;
        j = by;
        while (j < ey) {
            if (this.testimagemap(i, j)) {
                b.quad[0] = (float)i * this.wcoordsx;
                b.quad[1] = (float)j * this.wcoordsy;
                found = true;
                break;
            }
            ++j;
        }
        if (!found) {
            j = by;
            i = bx;
            while (i < cx) {
                if (this.testimagemap(i, j)) {
                    b.quad[0] = (float)i * this.wcoordsx;
                    b.quad[1] = (float)j * this.wcoordsy;
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                b.quad[0] = (float)b.boxcenterx * this.wcoordsx;
                b.quad[1] = (float)b.boxcentery * this.wcoordsy;
            }
        }
        found = false;
        i = ex;
        j = by;
        while (j < ey) {
            if (this.testimagemap(i, j)) {
                b.quad[2] = (float)i * this.wcoordsx;
                b.quad[3] = (float)j * this.wcoordsy;
                found = true;
                break;
            }
            ++j;
        }
        if (!found) {
            j = by;
            i = ex - 1;
            while (i > cx) {
                if (this.testimagemap(i, j)) {
                    b.quad[2] = (float)i * this.wcoordsx;
                    b.quad[3] = (float)j * this.wcoordsy;
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                b.quad[2] = (float)b.boxcenterx * this.wcoordsx;
                b.quad[3] = (float)b.boxcentery * this.wcoordsy;
            }
        }
        bx = PApplet.constrain((int)b.boxminx, (int)0, (int)(this.w - 1));
        ex = PApplet.constrain((int)b.boxmaxx, (int)0, (int)(this.w - 1));
        ey = PApplet.constrain((int)b.boxmaxy, (int)0, (int)(this.h - 1));
        cx = b.boxcenterx;
        cx = PApplet.constrain((int)cx, (int)0, (int)(this.w - 1));
        j = ey;
        i = bx;
        while (i < cx) {
            if (this.testimagemap(i, j)) {
                b.quad[4] = (float)i * this.wcoordsx;
                b.quad[5] = (float)j * this.wcoordsx;
                break;
            }
            ++i;
        }
        j = ey;
        i = ex - 1;
        while (i > cx) {
            if (this.testimagemap(i, j)) {
                b.quad[6] = (float)i * this.wcoordsx;
                b.quad[7] = (float)j * this.wcoordsy;
                break;
            }
            --i;
        }
        return b;
    }

    void copy_blobs_to_previousblobs() {
        this.prevnumblobs = this.numblobs;
        this.numblobs = 0;
        this.prevblobs.clear();
        int i = 0;
        while (i < this.theblobs.size()) {
            this.prevblobs.add(this.theblobs.get(i));
            ++i;
        }
        this.theblobs.clear();
    }

    public ArrayList<trackedBlob> calcsimpleAL() {
        this.trackedblobs.clear();
        int i = 0;
        while (i < this.theblobs.size()) {
            trackedBlob b2;
            ABlob ab = this.theblobs.get(i);
            trackedBlob b1 = new trackedBlob(ab);
            trackedBlob trackedBlob2 = b2 = i >= this.prevblobs.size() ? null : new trackedBlob(this.prevblobs.get(i));
            if (b2 != null) {
                b1.id = b2.id;
                b1.presencetime = b2.presencetime + 1;
                b1.prevelx = b2.velx;
                b1.prevely = b2.vely;
                b1.pboxcenterx = b2.boxcenterx;
                b1.pboxcentery = b2.boxcentery;
                b1.armleftx = ab.armleftx;
                b1.armlefty = ab.armlefty;
                b1.armrightx = ab.armrightx;
                b1.armrighty = ab.armrighty;
                b1.headx = ab.headx;
                b1.heady = ab.heady;
                b1.bottomx = ab.bottomx;
                b1.bottomy = ab.bottomy;
                b1.footleftx = ab.footleftx;
                b1.footlefty = ab.footlefty;
                b1.footrightx = ab.footrightx;
                b1.footrighty = ab.footrighty;
            } else {
                ++this.idnumbers;
                b1.id = b1.id;
                b1.pboxcenterx = ab.boxcenterx;
                b1.pboxcentery = ab.boxcentery;
                b1.prevelx = 0.0f;
                b1.prevely = 0.0f;
                b1.armleftx = ab.armleftx;
                b1.armlefty = ab.armlefty;
                b1.armrightx = ab.armrightx;
                b1.armrighty = ab.armrighty;
                b1.headx = ab.headx;
                b1.heady = ab.heady;
                b1.bottomx = ab.bottomx;
                b1.bottomy = ab.bottomy;
                b1.footleftx = ab.footleftx;
                b1.footlefty = ab.footlefty;
                b1.footrightx = ab.footrightx;
                b1.footrighty = ab.footrighty;
            }
            b1.cx = ab.cx;
            b1.cy = ab.cy;
            b1.boxcenterx = ab.boxcenterx;
            b1.boxcentery = ab.boxcentery;
            b1.velx += this.lp2 * b1.velx + this.lp1 * (float)(b1.boxcenterx - b1.pboxcenterx) * this.wr;
            b1.vely = this.lp2 * b1.vely + this.lp1 * (float)(b1.boxcentery - b1.pboxcentery) * this.hr;
            b1.boxminx = ab.boxminx;
            b1.boxmaxx = ab.boxmaxx;
            b1.boxminy = ab.boxminy;
            b1.boxmaxy = ab.boxmaxy;
            b1.boxdimx = ab.boxdimx;
            b1.boxdimy = ab.boxdimy;
            b1.dimx = ab.dimx;
            b1.dimy = ab.dimy;
            b1.rad = ab.boxdimx < ab.boxdimy ? (float)ab.boxdimx / 2.0f : (float)ab.boxdimy / 2.0f;
            b1.rad2 = b1.rad * b1.rad;
            this.trackedblobs.add(b1);
            ++i;
        }
        return this.trackedblobs;
    }

    public ArrayList<trackedBlob> tracksimpleAL() {
        this.prevtrackedblobs = new ArrayList();
        int i = 0;
        while (i < this.trackedblobs.size()) {
            this.prevtrackedblobs.add(this.trackedblobs.get(i));
            ++i;
        }
        this.trackedblobs.clear();
        int i2 = 0;
        while (i2 < this.theblobs.size()) {
            trackedBlob b2;
            ABlob ab = this.theblobs.get(i2);
            trackedBlob b1 = new trackedBlob(ab);
            trackedBlob trackedBlob2 = b2 = i2 >= this.prevnumblobs ? null : new trackedBlob(this.prevtrackedblobs.get(i2));
            if (b2 != null) {
                b1.id = b2.id;
                b1.prevelx = b2.velx;
                b1.prevely = b2.vely;
                b1.pcx = b2.cx;
                b1.pcy = b2.cy;
            } else {
                ++this.idnumbers;
                b1.id = b1.id;
                b1.pcx = ab.cx;
                b1.pcy = ab.cy;
                b1.prevelx = 0.0f;
                b1.prevely = 0.0f;
            }
            b1.cx = ab.cx;
            b1.cy = ab.cy;
            b1.velx = this.lp2 * b1.prevelx + this.lp1 * (b1.cx - b1.pcx);
            b1.vely = this.lp2 * b1.prevely + this.lp1 * (b1.cy - b1.pcy);
            b1.boxminx = ab.boxminx;
            b1.boxmaxx = ab.boxmaxx;
            b1.boxminy = ab.boxminy;
            b1.boxmaxy = ab.boxmaxy;
            b1.boxdimx = ab.boxdimx;
            b1.boxdimy = ab.boxdimy;
            b1.dimx = ab.dimx;
            b1.dimy = ab.dimy;
            b1.rad = ab.boxdimx < ab.boxdimy ? (float)ab.boxdimx / 2.0f : (float)ab.boxdimy / 2.0f;
            b1.rad2 = b1.rad * b1.rad;
            b1.armleftx = ab.armleftx;
            b1.armlefty = ab.armlefty;
            b1.armrightx = ab.armrightx;
            b1.armrighty = ab.armrighty;
            b1.headx = ab.headx;
            b1.heady = ab.heady;
            b1.bottomx = ab.bottomx;
            b1.bottomy = ab.bottomy;
            b1.footleftx = ab.footleftx;
            b1.footlefty = ab.footlefty;
            b1.footrightx = ab.footrightx;
            b1.footrighty = ab.footrighty;
            this.trackedblobs.add(b1);
            ++i2;
        }
        return this.trackedblobs;
    }

    void addTrackedBlob(trackedBlob b) {
        ++b.presencetime;
        ++this.trackednumblobs;
        this.trackedblobs.add(b);
    }

    void addNewBlob(trackedBlob b) {
        b.id = this.idnumbers++;
        b.birthtime = System.currentTimeMillis();
        b.presencetime = 0;
        ++this.trackednumblobs;
        this.trackedblobs.add(b);
    }

    void dotracking() {
        this.prevtrackednumblobs = this.trackednumblobs;
        this.trackednumblobs = 0;
        this.prevtrackedblobs.clear();
        int i = 0;
        while (i < this.trackedblobs.size()) {
            trackedBlob tb = this.trackedblobs.get(i);
            this.prevtrackedblobs.add(tb);
            ++i;
        }
        this.trackedblobs.clear();
        i = 0;
        while (i < this.prevtrackedblobs.size()) {
            this.prevtrackedblobs.get((int)i).linked = false;
            ++i;
        }
        if (this.numblobs > 0) {
            this.compareblobsprevblobs();
        }
        this.doremoveprevblobs();
        this.sorttrackedblobs();
        if (this.trackedblobs.size() < 1 && this.idnumbers != 0) {
            this.idnumbers = 0;
        }
    }

    void sorttrackedblobs() {
        ArrayList<trackedBlob> temp = new ArrayList<trackedBlob>();
        if (this.trackedblobs.size() > 0) {
            int i = this.trackedblobs.size() - 1;
            while (i >= 0) {
                int minid2 = 0x7FFFFFFE;
                int who = -1;
                int j = 0;
                while (j < this.trackedblobs.size()) {
                    trackedBlob tb = this.trackedblobs.get(i);
                    if (tb.id < minid2) {
                        minid2 = tb.id;
                        who = j;
                    }
                    ++j;
                }
                if (who > -1) {
                    temp.add(this.trackedblobs.remove(who));
                }
                --i;
            }
            i = 0;
            while (i < temp.size()) {
                this.trackedblobs.add((trackedBlob)temp.remove(i));
                ++i;
            }
        }
    }

    boolean matchblobprevtrackedblobs(ABlob ab) {
        boolean matched = false;
        float mintrackeddist = 10000.0f;
        int who = -1;
        float mindist = this.trackingmindist;
        int i = this.prevtrackedblobs.size() - 1;
        while (i >= 0) {
            float dy;
            float dx;
            float d2;
            trackedBlob prev = this.prevtrackedblobs.get(i);
            if (!prev.linked && (d2 = (dx = ab.cx - prev.cx) * dx + (dy = ab.cy - prev.cy) * dy) < mindist && d2 < mintrackeddist) {
                mintrackeddist = d2;
                who = i;
                matched = true;
            }
            --i;
        }
        if (matched) {
            trackedBlob b = this.prevtrackedblobs.remove(who);
            b.linked = true;
            b.newblob = false;
            ++b.presencetime;
            b.prevelx = b.velx;
            b.prevely = b.vely;
            b.pcx = b.cx;
            b.pcy = b.cy;
            b.cx = ab.cx;
            b.cy = ab.cy;
            b.velx = this.lp2 * b.prevelx + this.lp1 * (b.cx - b.pcx);
            b.vely = this.lp2 * b.prevely + this.lp1 * (b.cy - b.pcy);
            b.boxminx = ab.boxminx;
            b.boxmaxx = ab.boxmaxx;
            b.boxminy = ab.boxminy;
            b.boxmaxy = ab.boxmaxy;
            b.boxdimx = ab.boxdimx;
            b.boxdimy = ab.boxdimy;
            b.dimx = ab.dimx;
            b.dimy = ab.dimy;
            b.rad = ab.boxdimx < ab.boxdimy ? (float)ab.boxdimx / 2.0f : (float)ab.boxdimy / 2.0f;
            b.rad2 = b.rad * b.rad;
            b.armleftx = ab.armleftx;
            b.armlefty = ab.armlefty;
            b.armrightx = ab.armrightx;
            b.armrighty = ab.armrighty;
            b.headx = ab.headx;
            b.heady = ab.heady;
            b.bottomx = ab.bottomx;
            b.bottomy = ab.bottomy;
            b.footleftx = ab.footleftx;
            b.footlefty = ab.footlefty;
            b.footrightx = ab.footrightx;
            b.footrighty = ab.footrighty;
            this.trackedblobs.add(b);
        }
        return matched;
    }

    void compareblobsprevblobs() {
        int i = 0;
        while (i < this.theblobs.size()) {
            ABlob ab = this.theblobs.get(i);
            boolean matched = this.matchblobprevtrackedblobs(ab);
            if (!matched) {
                this.addNewBlob(new trackedBlob(ab));
            }
            ++i;
        }
    }

    void doremoveprevblobs() {
        int i = this.prevtrackedblobs.size() - 1;
        while (i >= 0) {
            trackedBlob tb = this.prevtrackedblobs.get(i);
            if (tb.linked) {
                System.out.print("flob: a linked blob in doremove error." + i + " \n");
            } else if (tb.lifetime-- < 0L) {
                this.prevtrackedblobs.remove(i);
            } else {
                trackedBlob b = this.prevtrackedblobs.remove(i);
                b.velx = 0.0f;
                b.vely = 0.0f;
                this.addTrackedBlob(b);
            }
            --i;
        }
    }

    void doaddnewtrackedblobs() {
        int i = 0;
        while (i < this.prevtrackedblobs.size()) {
            trackedBlob newtb = this.prevtrackedblobs.get(i);
            newtb.birthtime = System.currentTimeMillis();
            newtb.presencetime = 0;
            ++this.trackednumblobs;
            this.trackedblobs.add(newtb);
            ++i;
        }
    }

    void add_tracker_match(ABlob b, trackedBlob prev) {
        trackedBlob tb = new trackedBlob(b, prev);
        tb.prevelx = prev.velx;
        tb.prevely = prev.vely;
        tb.pcx = prev.cx;
        tb.pcy = prev.cy;
        tb.velx = tb.cx - prev.cx;
        tb.vely = tb.cy - prev.cy;
        ++tb.presencetime;
        this.trackedblobs.add(tb);
    }

    public boolean isCollide(int x, int y) {
        if (x >= 0 && x < this.w && y >= 0 && y < this.h) {
            int i = 0;
            while (i < this.theblobs.size()) {
                ABlob b = this.theblobs.get(i);
                if (x > b.boxminx && x < b.boxmaxx && y > b.boxminy && y < b.boxmaxy && this.imagemap[y * this.w + x]) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public float[] postcollidetrackedblobs(float x, float y, float rad) {
        float[] dcol = new float[]{0.0f, -1.0f, -1.0f, 0.0f, 0.0f};
        x *= (float)this.w;
        y *= (float)this.h;
        rad *= (float)this.w;
        if (x >= 0.0f && x < (float)this.w - 1.0f && y >= 0.0f && y < (float)this.h - 1.0f) {
            int i = 0;
            while (i < this.trackedblobs.size()) {
                float minsdist;
                float closex;
                trackedBlob b = this.trackedblobs.get(i);
                float f = x < (float)b.boxminx ? (float)b.boxminx : (closex = x > (float)b.boxmaxx ? (float)b.boxmaxx : x);
                float dx0 = closex - x;
                float closey = y < (float)b.boxminy ? (float)b.boxminy : (y > (float)b.boxmaxy ? (float)b.boxmaxy : y);
                float dy0 = closey - y;
                float d0 = dx0 * dx0 + dy0 * dy0;
                if (d0 < (minsdist = rad * rad + b.rad2) && this.imagemap[(int)y * this.w + (int)x]) {
                    float nvx = (float)b.boxcenterx - closex;
                    float nvy = (float)b.boxcentery - closey;
                    float d1 = Math.abs(nvx) + Math.abs(nvy);
                    float nvl = d1 > 0.0f ? 1.0f / d1 : 1.0f;
                    nvx *= nvl;
                    nvy *= nvl;
                    float move = rad - d1 + 1.0E-4f;
                    dcol[0] = 1.0f;
                    dcol[1] = (nvx *= move) * this.wr;
                    dcol[2] = (nvy *= move) * this.hr;
                    dcol[3] = b.velx * this.wr;
                    dcol[4] = b.vely * this.hr;
                    return dcol;
                }
                ++i;
            }
        }
        return dcol;
    }

    public float[] postcollideblobs(float x, float y, float rad) {
        float[] dcol = new float[]{0.0f, -1.0f, -1.0f, 0.0f, 0.0f};
        x *= (float)this.w;
        y *= (float)this.h;
        rad *= (float)this.w;
        if (x >= 0.0f && x < (float)this.w && y >= 0.0f && y < (float)this.h) {
            int i = 0;
            while (i < this.trackedblobs.size()) {
                float minsdist;
                float closex;
                trackedBlob b = this.trackedblobs.get(i);
                float f = x < (float)b.boxminx ? (float)b.boxminx : (closex = x > (float)b.boxmaxx ? (float)b.boxmaxx : x);
                float dx0 = closex - x;
                float closey = y < (float)b.boxminy ? (float)b.boxminy : (y > (float)b.boxmaxy ? (float)b.boxmaxy : y);
                float dy0 = closey - y;
                float d0 = dx0 * dx0 + dy0 * dy0;
                if (d0 < (minsdist = rad * rad + b.rad2) && this.imagemap[(int)(y * (float)this.w + x)]) {
                    float nvx = (float)b.boxcenterx - closex;
                    float nvy = (float)b.boxcentery - closey;
                    float d1 = Math.abs(nvx) + Math.abs(nvy);
                    float nvl = d1 > 0.0f ? 1.0f / d1 : 1.0f;
                    nvx *= nvl;
                    nvy *= nvl;
                    float move = rad - d1 + 1.0E-4f;
                    dcol[0] = 1.0f;
                    dcol[1] = (nvx *= move) * this.wr;
                    dcol[2] = (nvy *= move) * this.hr;
                    dcol[3] = b.velx * this.wr;
                    dcol[4] = b.vely * this.hr;
                    return dcol;
                }
                ++i;
            }
        }
        return dcol;
    }
}

