/*
 * Decompiled with CFR 0.152.
 */
package s373.flob;

import java.io.File;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import processing.core.PApplet;
import processing.core.PImage;
import s373.flob.ABlob;
import s373.flob.ImageBlobs;
import s373.flob.quadBlob;
import s373.flob.trackedBlob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Flob {
    public ImageBlobs imageblobs;
    public PImage videoimg;
    public PImage videotex;
    public PImage videotexmotion;
    public PImage videotexbin;
    public PImage videoteximgmotion;
    public int[] backgroundPixels;
    public int numPixels;
    public int videoresw = 128;
    public int videoresh = 128;
    public int presence = 0;
    public int videotexmode;
    public int pvideotexmode = 10000;
    public boolean videotexchange = true;
    public int videothresh = 50;
    public int videofade = 50;
    public boolean mirrorX;
    public boolean mirrorY;
    public int worldwidth;
    public int worldheight;
    public boolean coordsmode = true;
    public int blur = 0;
    public boolean[] trackfeatures = new boolean[5];
    public int om = 0;
    public static final int STATIC_DIFFERENCE = 0;
    public static final int CONTINUOUS_DIFFERENCE = 1;
    public static final int CONTINUOUS_EASE_DIFFERENCE = 2;
    public float continuous_ease = 0.05f;
    public int colormode = 1;
    public static final int RED = 0;
    public static final int GREEN = 1;
    public static final int BLUE = 2;
    public static final int LUMA601 = 3;
    public static final int LUMA709 = 4;
    public static final int LUMAUSER = 5;
    public float[] lumausercoefs = new float[]{0.1f, 0.75f, 0.25f};
    public int blobpixmin = 0;
    public int blobpixmax = 0;
    public static String redstr = "RED";
    public static String greenstr = "GREEN";
    public static String bluestr = "BLUE";
    public static String luma601str = "LUMA601";
    public static String luma709str = "LUMA709";
    public static String lumausrstr = "LUMAUSER";
    private String colorModeStr = "";
    public static int trackedBlobLifeTime = 5;
    public static String VERSION = "flob 0.0.1s - built ";

    public Flob(PApplet theParent) {
        this.videoresh = 128;
        this.videoresw = 128;
        this.worldwidth = theParent.width;
        this.worldheight = theParent.height;
        this.setup();
    }

    public Flob(PImage video, PApplet theParent) {
        this.videoresw = video.width;
        this.videoresh = video.height;
        this.worldwidth = theParent.width;
        this.worldheight = theParent.height;
        this.setup();
    }

    public Flob(PImage video, int w, int h) {
        this.videoresw = video.width;
        this.videoresh = video.height;
        this.worldwidth = w;
        this.worldheight = h;
        this.setup();
    }

    public Flob(int srcW, int srcH, int dstW, int dstH) {
        this.videoresw = srcW;
        this.videoresh = srcH;
        this.worldwidth = dstW;
        this.worldheight = dstH;
        this.setup();
    }

    void setup() {
        this.trackfeatures = new boolean[5];
        int i = 0;
        while (i < 5) {
            this.trackfeatures[i] = false;
            ++i;
        }
        this.videoimg = new PImage(this.videoresw, this.videoresh);
        this.videotexbin = new PImage(this.videoresw, this.videoresh);
        this.videotexmotion = new PImage(this.videoresw, this.videoresh);
        this.videoteximgmotion = new PImage(this.videoresw, this.videoresh);
        this.videotex = new PImage(this.videoresw, this.videoresh);
        this.numPixels = this.videoresw * this.videoresh;
        this.backgroundPixels = new int[this.numPixels];
        this.imageblobs = new ImageBlobs(this);
        this.version();
    }

    public PImage binarize(int[] pix) {
        PImage img = new PImage(this.videoresw, this.videoresh);
        img.pixels = pix;
        return this.binarize(img);
    }

    public PImage binarize(PImage video) {
        int[] scanline;
        int i;
        int j;
        int i2;
        this.videoimg = video;
        if (this.blur > 0) {
            this.videoimg = this.fastblur(this.videoimg, this.blur);
        }
        this.videoimg.loadPixels();
        if (this.mirrorX && this.mirrorY) {
            int[] image = new int[this.numPixels];
            i2 = 0;
            while (i2 < this.numPixels) {
                image[i2] = this.videoimg.pixels[i2];
                ++i2;
            }
            j = 0;
            while (j < this.videoresh) {
                i = 0;
                while (i < this.videoresw) {
                    this.videoimg.pixels[j * this.videoresw + i] = image[this.videoresw - i - 1 + (this.videoresh - j - 1) * this.videoresw];
                    ++i;
                }
                ++j;
            }
            this.videoimg.updatePixels();
        } else if (this.mirrorX && !this.mirrorY) {
            scanline = new int[this.videoresw];
            j = 0;
            while (j < this.videoresh) {
                i = 0;
                while (i < this.videoresw) {
                    scanline[this.videoresw - i - 1] = this.videoimg.pixels[j * this.videoresw + i];
                    this.videoimg.pixels[j * this.videoresw + i] = scanline[i];
                    ++i;
                }
                ++j;
            }
            this.videoimg.updatePixels();
        } else if (!this.mirrorX && this.mirrorY) {
            scanline = new int[this.videoresh];
            i2 = 0;
            while (i2 < this.videoresw) {
                int j2 = 0;
                while (j2 < this.videoresh) {
                    scanline[this.videoresh - j2 - 1] = this.videoimg.pixels[j2 * this.videoresw + i2];
                    this.videoimg.pixels[j2 * this.videoresw + i2] = scanline[j2];
                    ++j2;
                }
                ++i2;
            }
            this.videoimg.updatePixels();
        }
        this.presence = 0;
        this.videoimg.loadPixels();
        int currentVal = 0;
        int backgroundVal = 0;
        int diffVal = 0;
        if (this.om == 0) {
            int i3 = 0;
            while (i3 < this.numPixels) {
                int currColor = this.videoimg.pixels[i3];
                int bkgdColor = this.backgroundPixels[i3];
                switch (this.colormode) {
                    case 0: {
                        currentVal = currColor & 0xFF;
                        backgroundVal = bkgdColor & 0xFF;
                        break;
                    }
                    case 1: {
                        currentVal = currColor >> 8 & 0xFF;
                        backgroundVal = bkgdColor >> 8 & 0xFF;
                        break;
                    }
                    default: {
                        currentVal = currColor >> 16 & 0xFF;
                        backgroundVal = bkgdColor >> 16 & 0xFF;
                        break;
                    }
                    case 3: {
                        float pixval = (float)((double)(0.299f * (float)(currColor & 0xFF)) + 0.587 * (double)(currColor >> 8 & 0xFF) + 0.114 * (double)(currColor >> 16 & 0xFF)) + 0.5f;
                        float bgval = (float)((double)(0.299f * (float)(bkgdColor & 0xFF)) + 0.587 * (double)(bkgdColor >> 8 & 0xFF) + 0.114 * (double)(bkgdColor >> 16 & 0xFF)) + 0.5f;
                        currentVal = (int)pixval;
                        backgroundVal = (int)bgval;
                        break;
                    }
                    case 4: {
                        float pixval1 = (float)((double)(0.2126f * (float)(currColor & 0xFF)) + 0.7152 * (double)(currColor >> 8 & 0xFF) + 0.0722 * (double)(currColor >> 16 & 0xFF)) + 0.5f;
                        float bgval1 = (float)((double)(0.2126f * (float)(bkgdColor & 0xFF)) + 0.7152 * (double)(bkgdColor >> 8 & 0xFF) + 0.0722 * (double)(bkgdColor >> 16 & 0xFF)) + 0.5f;
                        currentVal = (int)pixval1;
                        backgroundVal = (int)bgval1;
                        break;
                    }
                    case 5: {
                        float pixval2 = this.lumausercoefs[0] * (float)(currColor & 0xFF) + this.lumausercoefs[1] * (float)(currColor >> 8 & 0xFF) + this.lumausercoefs[2] * (float)(currColor >> 16 & 0xFF) + 0.5f;
                        float bgval2 = this.lumausercoefs[0] * (float)(bkgdColor & 0xFF) + this.lumausercoefs[1] * (float)(bkgdColor >> 8 & 0xFF) + this.lumausercoefs[2] * (float)(bkgdColor >> 16 & 0xFF) + 0.5f;
                        currentVal = (int)pixval2;
                        backgroundVal = (int)bgval2;
                    }
                }
                diffVal = Math.abs(currentVal - backgroundVal);
                int binarize = 0;
                if (diffVal > this.videothresh) {
                    ++this.presence;
                    binarize = 255;
                }
                this.videotexbin.pixels[i3] = binarize << 24 | binarize << 16 | binarize << 8 | binarize;
                ++i3;
            }
            this.videoimg.updatePixels();
            this.videotexbin.updatePixels();
            return this.videotexbin;
        }
        if (this.om >= 1) {
            int i4 = 0;
            while (i4 < this.numPixels) {
                int currColor = video.pixels[i4];
                int bkgdColor = this.backgroundPixels[i4];
                switch (this.colormode) {
                    case 0: {
                        currentVal = currColor & 0xFF;
                        backgroundVal = bkgdColor & 0xFF;
                        break;
                    }
                    case 1: {
                        currentVal = currColor >> 8 & 0xFF;
                        backgroundVal = bkgdColor >> 8 & 0xFF;
                        break;
                    }
                    default: {
                        currentVal = currColor >> 16 & 0xFF;
                        backgroundVal = bkgdColor >> 16 & 0xFF;
                        break;
                    }
                    case 3: {
                        float pixval = (float)((double)(0.299f * (float)(currColor & 0xFF)) + 0.587 * (double)(currColor >> 8 & 0xFF) + 0.114 * (double)(currColor >> 16 & 0xFF)) + 0.5f;
                        float bgval = (float)((double)(0.299f * (float)(bkgdColor & 0xFF)) + 0.587 * (double)(bkgdColor >> 8 & 0xFF) + 0.114 * (double)(bkgdColor >> 16 & 0xFF)) + 0.5f;
                        currentVal = (int)pixval;
                        backgroundVal = (int)bgval;
                        break;
                    }
                    case 4: {
                        float pixval1 = (float)((double)(0.2126f * (float)(currColor & 0xFF)) + 0.7152 * (double)(currColor >> 8 & 0xFF) + 0.0722 * (double)(currColor >> 16 & 0xFF)) + 0.5f;
                        float bgval1 = (float)((double)(0.2126f * (float)(bkgdColor & 0xFF)) + 0.7152 * (double)(bkgdColor >> 8 & 0xFF) + 0.0722 * (double)(bkgdColor >> 16 & 0xFF)) + 0.5f;
                        currentVal = (int)pixval1;
                        backgroundVal = (int)bgval1;
                        break;
                    }
                    case 5: {
                        float pixval2 = this.lumausercoefs[0] * (float)(currColor & 0xFF) + this.lumausercoefs[1] * (float)(currColor >> 8 & 0xFF) + this.lumausercoefs[2] * (float)(currColor >> 16 & 0xFF) + 0.5f;
                        float bgval2 = this.lumausercoefs[0] * (float)(bkgdColor & 0xFF) + this.lumausercoefs[1] * (float)(bkgdColor >> 8 & 0xFF) + this.lumausercoefs[2] * (float)(bkgdColor >> 16 & 0xFF) + 0.5f;
                        currentVal = (int)pixval2;
                        backgroundVal = (int)bgval2;
                    }
                }
                diffVal = Math.abs(currentVal - backgroundVal);
                int binarize = 0;
                if (diffVal > this.videothresh) {
                    ++this.presence;
                    binarize = 255;
                }
                this.videotexbin.pixels[i4] = binarize << 24 | binarize << 16 | binarize << 8 | binarize;
                ++i4;
            }
            this.videotexmotion.loadPixels();
            i4 = 0;
            while (i4 < this.numPixels) {
                int value = this.videotexmotion.pixels[i4] >> 8 & 0xFF;
                value -= this.videofade;
                value = (value += this.videotexbin.pixels[i4] >> 8 & 0xFF) < 0 ? 0 : (value > 255 ? 255 : value);
                this.videotexmotion.pixels[i4] = value << 24 | value << 16 | value << 8 | value;
                ++i4;
            }
            this.videoimg.updatePixels();
            this.videotexmotion.updatePixels();
            if (this.om == 1) {
                this.setBackground(this.videoimg);
            }
            if (this.om == 2) {
                this.easeBackground(this.videoimg);
            }
            return this.videotexmotion;
        }
        return this.videotexbin;
    }

    public PImage getSrcImage() {
        return this.updateVideoTex();
    }

    public PImage updateVideoTex() {
        if (this.videotexmode > 9) {
            return this.videoimg;
        }
        if (this.videotexmode == 3) {
            this.videoteximgmotion.loadPixels();
            this.videoimg.loadPixels();
            this.videotexmotion.loadPixels();
            this.videotexbin.loadPixels();
            int i = 0;
            while (i < this.numPixels) {
                int pixtexmotion = this.om == 0 ? this.videotexbin.pixels[i] : this.videotexmotion.pixels[i];
                int piximg = this.videoimg.pixels[i];
                int pixr = (pixtexmotion >> 16 & 0xFF) + (piximg >> 16 & 0xFF);
                pixr = pixr > 255 ? 255 : pixr;
                int pixg = (pixtexmotion >> 8 & 0xFF) + (piximg >> 8 & 0xFF);
                pixg = pixg > 255 ? 255 : pixg;
                int pixb = (pixtexmotion & 0xFF) + (piximg & 0xFF);
                pixb = pixb > 255 ? 255 : pixb;
                this.videoteximgmotion.pixels[i] = pixtexmotion << 24 | pixr << 16 | pixg << 8 | pixb;
                ++i;
            }
            this.videoteximgmotion.updatePixels();
        }
        this.pvideotexmode = this.videotexmode;
        switch (this.videotexmode) {
            default: {
                this.videotex = this.videoimg;
                break;
            }
            case 1: {
                this.videotex = this.videotexbin;
                break;
            }
            case 2: {
                this.videotex = this.videotexmotion;
                break;
            }
            case 3: {
                this.videotex = this.videoteximgmotion;
            }
        }
        return this.videotex;
    }

    public Flob setVideoTex(int t) {
        this.videotexmode = t;
        this.videotexchange = true;
        return this;
    }

    public Flob setImage(int t) {
        this.setSrcImage(t);
        return this;
    }

    public PImage getImage() {
        return this.getSrcImage();
    }

    public Flob setSrcImage(int t) {
        this.videotexmode = t;
        this.videotexchange = true;
        return this;
    }

    public Flob setTrackFeatures(boolean[] tf) {
        int i = 0;
        while (i < tf.length) {
            this.trackfeatures[i] = tf[i];
            ++i;
        }
        return this;
    }

    public boolean[] getTrackFeatures() {
        return this.trackfeatures;
    }

    public boolean getAnyFeatureActive() {
        boolean active = this.trackfeatures[0] || this.trackfeatures[1] || this.trackfeatures[2] || this.trackfeatures[3] || this.trackfeatures[4];
        return active;
    }

    public Flob setOm(int t) {
        this.om = t > 1 ? 2 : (t > 0 ? 1 : 0);
        return this;
    }

    public int getOm() {
        return this.om;
    }

    public Flob settrackedBlobLifeTime(int t) {
        trackedBlobLifeTime = t;
        return this;
    }

    public int gettrackedBlobLifeTime() {
        return trackedBlobLifeTime;
    }

    public Flob setCoordsMode(boolean t) {
        this.coordsmode = t;
        return this;
    }

    public boolean getCoordsMode() {
        return this.coordsmode;
    }

    public Flob setColorMode(int t) {
        this.colormode = t < 0 ? 0 : (t > 5 ? 5 : t);
        return this;
    }

    public String getColorMode() {
        switch (this.colormode) {
            case 0: {
                this.colorModeStr = redstr;
                break;
            }
            case 1: {
                this.colorModeStr = greenstr;
                break;
            }
            case 2: {
                this.colorModeStr = bluestr;
                break;
            }
            case 3: {
                this.colorModeStr = luma601str;
                break;
            }
            case 4: {
                this.colorModeStr = luma709str;
                break;
            }
            case 5: {
                this.colorModeStr = lumausrstr;
            }
        }
        return this.colorModeStr;
    }

    public Flob setLumaUserCoefs(float[] data) {
        this.lumausercoefs[0] = data[0];
        this.lumausercoefs[1] = data[1];
        this.lumausercoefs[2] = data[2];
        return this;
    }

    public float[] getLumaUserCoefs() {
        return this.lumausercoefs;
    }

    public Flob setBackground(PImage video) {
        video.loadPixels();
        System.arraycopy(video.pixels, 0, this.backgroundPixels, 0, video.pixels.length);
        return this;
    }

    public Flob easeBackground(PImage video) {
        video.loadPixels();
        int i = 0;
        while (i < this.numPixels) {
            int n = i;
            this.backgroundPixels[n] = (int)((float)this.backgroundPixels[n] + (float)(video.pixels[i] - this.backgroundPixels[i]) * this.continuous_ease);
            ++i;
        }
        return this;
    }

    public int[] getBackground() {
        return this.backgroundPixels;
    }

    public Flob setTresh(int t) {
        this.videothresh = t;
        return this;
    }

    public Flob setThresh(int t) {
        this.videothresh = t;
        return this;
    }

    public int getThresh() {
        return this.videothresh;
    }

    public Flob setFade(int t) {
        this.videofade = t;
        return this;
    }

    public int getFade() {
        return this.videofade;
    }

    public Flob mirrorX(boolean m) {
        this.mirrorX = m;
        return this;
    }

    public Flob mirrorY(boolean m) {
        this.mirrorY = m;
        return this;
    }

    public Flob setMirror(boolean m0, boolean m1) {
        this.mirrorX = m0;
        this.mirrorY = m1;
        return this;
    }

    public boolean[] getMirror() {
        boolean[] m = new boolean[]{this.mirrorX, this.mirrorY};
        return m;
    }

    public Flob setMinNumPixels(int t) {
        this.imageblobs.ninpix = t;
        return this;
    }

    public Flob setMaxNumPixels(int t) {
        this.imageblobs.setmaxpix(t);
        return this;
    }

    public int getMinNumPixels() {
        return this.imageblobs.ninpix;
    }

    public int getMaxNumPixels() {
        return this.imageblobs.maxpix;
    }

    public Flob setTrackingMinDist(float s) {
        this.imageblobs.trackingmindist = s;
        return this;
    }

    public float getTrackingMinDist() {
        return this.imageblobs.trackingmindist;
    }

    public Flob setSmooth(float s) {
        this.imageblobs.setSmoothib(s);
        return this;
    }

    public float getSmooth() {
        return this.imageblobs.lp1;
    }

    public Flob setBlur(int blur) {
        this.blur = blur;
        return this;
    }

    public int getBlur() {
        return this.blur;
    }

    public ArrayList<ABlob> calc(PImage img) {
        this.imageblobs.calc(img);
        return this.imageblobs.theblobs;
    }

    public ArrayList<trackedBlob> track(PImage img) {
        this.imageblobs.calc(img);
        this.imageblobs.dotracking();
        return this.imageblobs.trackedblobs;
    }

    public ArrayList<trackedBlob> tracksimple(PImage img) {
        this.imageblobs.calc(img);
        return this.imageblobs.tracksimpleAL();
    }

    public ArrayList<trackedBlob> calcsimple(PImage img) {
        this.imageblobs.calc(img);
        return this.imageblobs.calcsimpleAL();
    }

    public ArrayList<quadBlob> calcQuad(PImage img) {
        this.imageblobs.calcQuad(img);
        return this.imageblobs.quadblobslist;
    }

    public trackedBlob getTrackedBlob(int i) {
        trackedBlob tb = this.imageblobs.trackedblobs.get(i);
        return tb;
    }

    public trackedBlob getPreviousTrackedBlob(int i) {
        trackedBlob tb = this.imageblobs.prevtrackedblobs.get(i);
        return tb;
    }

    public ABlob getABlob(int i) {
        ABlob ab = this.imageblobs.theblobs.get(i);
        return ab;
    }

    public quadBlob getQuadBlob(int i) {
        quadBlob qb = this.imageblobs.quadblobslist.get(i);
        return qb;
    }

    public ABlob getPreviousABlob(int i) {
        ABlob ab = this.imageblobs.prevblobs.get(i);
        return ab;
    }

    public float[] getTrackedSimpleBlob(int i) {
        float[] data = new float[12];
        trackedBlob tb = this.imageblobs.trackedblobs.get(i);
        data[0] = tb.id;
        data[1] = tb.cx * (float)this.worldwidth;
        data[2] = tb.cy * (float)this.worldheight;
        data[3] = tb.velx * (float)this.worldwidth;
        data[4] = tb.vely * (float)this.worldheight;
        data[5] = tb.prevelx * (float)this.worldwidth;
        data[6] = tb.prevely * (float)this.worldheight;
        data[7] = tb.presencetime;
        data[8] = tb.dimx * (float)this.worldwidth;
        data[9] = tb.dimy * (float)this.worldheight;
        data[10] = tb.rad * (float)this.worldwidth;
        data[11] = tb.birthtime;
        return data;
    }

    public int getNumBlobs() {
        return this.imageblobs.theblobs.size();
    }

    public int getNumTrackedBlobs() {
        return this.imageblobs.trackedblobs.size();
    }

    public int getNumTrackedSimpleBlobs() {
        return this.imageblobs.tbsimplelist.size();
    }

    public int getNumQuadBlobs() {
        return this.imageblobs.quadblobslist.size();
    }

    public float[] getTrackedBlobf(int i) {
        float[] data = new float[12];
        trackedBlob tb = this.imageblobs.trackedblobs.get(i);
        data[0] = tb.id;
        data[1] = tb.cx * (float)this.worldwidth;
        data[2] = tb.cy * (float)this.worldheight;
        data[3] = tb.velx * (float)this.worldwidth;
        data[4] = tb.vely * (float)this.worldheight;
        data[5] = tb.prevelx * (float)this.worldwidth;
        data[6] = tb.prevely * (float)this.worldheight;
        data[7] = tb.presencetime;
        data[8] = tb.dimx * (float)this.worldwidth;
        data[9] = tb.dimy * (float)this.worldheight;
        data[10] = tb.rad * (float)this.worldwidth;
        data[11] = tb.birthtime;
        return data;
    }

    public int getPresence() {
        return this.presence;
    }

    public float getPresencef() {
        return (float)this.presence / (float)this.numPixels;
    }

    public float[] getCentroids() {
        int numblobs = this.imageblobs.theblobs.size();
        float[] centroids = new float[2 * numblobs];
        int i = 0;
        while (i < numblobs) {
            ABlob blob = this.imageblobs.theblobs.get(i);
            centroids[i * 2 + 0] = blob.cx * (float)this.worldwidth;
            centroids[i * 2 + 1] = blob.cy * (float)this.worldheight;
            ++i;
        }
        return centroids;
    }

    public float[] getPreviousCentroids() {
        int numblobs = this.imageblobs.prevblobs.size();
        float[] centroids = new float[2 * numblobs];
        int i = 0;
        while (i < numblobs) {
            ABlob blob = this.imageblobs.prevblobs.get(i);
            centroids[i * 2 + 0] = blob.cx * (float)this.worldwidth;
            centroids[i * 2 + 1] = blob.cy * (float)this.worldheight;
            ++i;
        }
        return centroids;
    }

    public float[] getCentroid(int i) {
        float[] centroid = new float[2];
        ABlob blob = this.imageblobs.theblobs.get(i);
        centroid[0] = blob.cx;
        centroid[1] = blob.cy;
        return centroid;
    }

    public float[] getCentroidPixelcount(int i) {
        float[] centroid = new float[3];
        ABlob blob = this.imageblobs.theblobs.get(i);
        centroid[0] = blob.cx;
        centroid[1] = blob.cy;
        centroid[2] = blob.pixelcount;
        return centroid;
    }

    public float[] getPreviousCurrentCentroid(int i) {
        float[] centroid = new float[4];
        ABlob blob = this.imageblobs.theblobs.get(i);
        centroid[0] = blob.cx * (float)this.worldwidth;
        centroid[1] = blob.cy * (float)this.worldheight;
        return centroid;
    }

    public float[] getPreviousCurrentCentroidMass(int i) {
        float[] centroid = new float[5];
        ABlob blob = this.imageblobs.theblobs.get(i);
        centroid[0] = blob.cx * (float)this.worldwidth;
        centroid[1] = blob.cy * (float)this.worldheight;
        centroid[4] = blob.pixelcount;
        return centroid;
    }

    public float[] getDim(int i) {
        float[] centroid = new float[2];
        ABlob blob = this.imageblobs.theblobs.get(i);
        centroid[0] = blob.dimx * (float)this.worldwidth;
        centroid[1] = blob.dimy * (float)this.worldheight;
        return centroid;
    }

    public int[] getBox(int i) {
        int[] box = new int[4];
        ABlob blob = this.imageblobs.theblobs.get(i);
        box[0] = blob.boxminx;
        box[1] = blob.boxminy;
        box[2] = blob.boxmaxx;
        box[3] = blob.boxmaxy;
        return box;
    }

    public boolean testPos(int x, int y) {
        boolean px = false;
        try {
            px = this.imageblobs.imagemap[y * this.imageblobs.w + x];
        }
        catch (Exception e) {
            System.out.print("flob.testPos(x,y) access out of bound with : " + x + " " + y + "\n" + e + "\n");
        }
        return px;
    }

    public boolean testPos(float x, float y) {
        x = PApplet.constrain((float)x, (float)0.0f, (float)1.0f);
        y = PApplet.constrain((float)y, (float)0.0f, (float)1.0f);
        int px = (int)(x * (float)this.imageblobs.w);
        int py = (int)(y * (float)this.imageblobs.h);
        return this.imageblobs.imagemap[py * this.imageblobs.w + px];
    }

    public PImage fastblur(PImage img, int radius) {
        int p2;
        int p1;
        int x;
        int rsum;
        int gsum;
        int bsum;
        if (radius < 1) {
            return img;
        }
        int w = img.width;
        int h = img.height;
        int wm = w - 1;
        int hm = h - 1;
        int wh = w * h;
        int div = radius + radius + 1;
        int[] r = new int[wh];
        int[] g = new int[wh];
        int[] b = new int[wh];
        int[] vmin = new int[Math.max(w, h)];
        int[] vmax = new int[Math.max(w, h)];
        int[] pix = img.pixels;
        int[] dv = new int[256 * div];
        int i = 0;
        while (i < 256 * div) {
            dv[i] = i / div;
            ++i;
        }
        int yi = 0;
        int yw = 0;
        int y = 0;
        while (y < h) {
            bsum = 0;
            gsum = 0;
            rsum = 0;
            i = -radius;
            while (i <= radius) {
                int p = pix[yi + Math.min(wm, Math.max(i, 0))];
                rsum += (p & 0xFF0000) >> 16;
                gsum += (p & 0xFF00) >> 8;
                bsum += p & 0xFF;
                ++i;
            }
            x = 0;
            while (x < w) {
                r[yi] = dv[rsum];
                g[yi] = dv[gsum];
                b[yi] = dv[bsum];
                if (y == 0) {
                    vmin[x] = Math.min(x + radius + 1, wm);
                    vmax[x] = Math.max(x - radius, 0);
                }
                p1 = pix[yw + vmin[x]];
                p2 = pix[yw + vmax[x]];
                rsum += (p1 & 0xFF0000) - (p2 & 0xFF0000) >> 16;
                gsum += (p1 & 0xFF00) - (p2 & 0xFF00) >> 8;
                bsum += (p1 & 0xFF) - (p2 & 0xFF);
                ++yi;
                ++x;
            }
            yw += w;
            ++y;
        }
        x = 0;
        while (x < w) {
            bsum = 0;
            gsum = 0;
            rsum = 0;
            int yp = -radius * w;
            i = -radius;
            while (i <= radius) {
                yi = Math.max(0, yp) + x;
                rsum += r[yi];
                gsum += g[yi];
                bsum += b[yi];
                yp += w;
                ++i;
            }
            yi = x;
            y = 0;
            while (y < h) {
                pix[yi] = 0xFF000000 | dv[rsum] << 16 | dv[gsum] << 8 | dv[bsum];
                if (x == 0) {
                    vmin[y] = Math.min(y + radius + 1, hm) * w;
                    vmax[y] = Math.max(y - radius, 0) * w;
                }
                p1 = x + vmin[y];
                p2 = x + vmax[y];
                rsum += r[p1] - r[p2];
                gsum += g[p1] - g[p2];
                bsum += b[p1] - b[p2];
                yi += w;
                ++y;
            }
            ++x;
        }
        img.updatePixels();
        return img;
    }

    public String version() {
        try {
            File jarFile = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI());
            VERSION = "\n" + VERSION + new Date(jarFile.lastModified()) + " - http://s373.net/code/flob \n\n";
        }
        catch (URISyntaxException e1) {
            System.out.print("flob couldnt access file version. " + e1);
        }
        System.out.print(VERSION);
        return VERSION;
    }
}

