/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.ugens.Waveform;
import java.util.Random;

public class Wavetable
implements Waveform {
    private float[] waveform;
    private float lengthForValue;

    public Wavetable(int size) {
        this.waveform = new float[size];
        this.lengthForValue = size - 1;
    }

    public Wavetable(float[] waveform) {
        this.waveform = waveform;
        this.lengthForValue = waveform.length - 1;
    }

    public Wavetable(Wavetable wavetable) {
        this.waveform = new float[wavetable.waveform.length];
        System.arraycopy(wavetable.waveform, 0, this.waveform, 0, this.waveform.length);
        this.lengthForValue = this.waveform.length - 1;
    }

    public void setWaveform(float[] waveform) {
        this.waveform = waveform;
        this.lengthForValue = waveform.length - 1;
    }

    public float get(int i) {
        return this.waveform[i];
    }

    public float value(float at) {
        float whichSample = this.lengthForValue * at;
        int lowSamp = (int)whichSample;
        int hiSamp = lowSamp + 1;
        if (hiSamp >= this.waveform.length) {
            hiSamp -= this.waveform.length;
        }
        float rem = whichSample - (float)lowSamp;
        return this.waveform[lowSamp] + rem * (this.waveform[hiSamp] - this.waveform[lowSamp]);
    }

    public float[] getWaveform() {
        return this.waveform;
    }

    public void set(int i, float value) {
        this.waveform[i] = value;
    }

    public int size() {
        return this.waveform.length;
    }

    public void scale(float scale) {
        int i = 0;
        while (i < this.waveform.length) {
            int n = i++;
            this.waveform[n] = this.waveform[n] * scale;
        }
    }

    public void offset(float amount) {
        int i = 0;
        while (i < this.waveform.length) {
            int n = i++;
            this.waveform[n] = this.waveform[n] + amount;
        }
    }

    public void normalize() {
        float max = Float.MIN_VALUE;
        int i = 0;
        while (i < this.waveform.length) {
            if (Math.abs(this.waveform[i]) > max) {
                max = Math.abs(this.waveform[i]);
            }
            ++i;
        }
        this.scale(1.0f / max);
    }

    public void invert() {
        this.flip(0.0f);
    }

    public void flip(float in) {
        int i = 0;
        while (i < this.waveform.length) {
            this.waveform[i] = this.waveform[i] > in ? in - (this.waveform[i] - in) : in + (in - this.waveform[i]);
            ++i;
        }
    }

    public void addNoise(float sigma) {
        Random rgen = new Random();
        int i = 0;
        while (i < this.waveform.length) {
            int n = i++;
            this.waveform[n] = this.waveform[n] + (float)rgen.nextGaussian() * sigma;
        }
    }

    public void rectify() {
        int i = 0;
        while (i < this.waveform.length) {
            if (this.waveform[i] < 0.0f) {
                int n = i;
                this.waveform[n] = this.waveform[n] * -1.0f;
            }
            ++i;
        }
    }

    public void smooth(int windowLength) {
        if (windowLength < 1) {
            return;
        }
        float[] temp = (float[])this.waveform.clone();
        int i = windowLength;
        while (i < this.waveform.length) {
            float avg = 0.0f;
            int j = i - windowLength;
            while (j <= i) {
                avg += temp[j] / (float)windowLength;
                ++j;
            }
            this.waveform[i] = avg;
            ++i;
        }
    }
}

