/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.ugens.Wavetable;
import ddf.minim.ugens.WavetableGenerator;

public class Waves {
    private static int tableSize = 8192;
    private static int tSby2 = tableSize / 2;
    private static int tSby4 = tableSize / 4;
    public static final Wavetable SINE = WavetableGenerator.gen10(tableSize, new float[]{1.0f});
    public static final Wavetable SAW;
    public static final Wavetable PHASOR;
    public static final Wavetable SQUARE;
    public static final Wavetable TRIANGLE;
    public static final Wavetable QUARTERPULSE;

    static {
        int[] nArray = new int[3];
        nArray[0] = tSby2;
        nArray[2] = tableSize - tSby2;
        SAW = WavetableGenerator.gen7(tableSize, new float[]{0.0f, -1.0f, 1.0f, 0.0f}, nArray);
        PHASOR = WavetableGenerator.gen7(tableSize, new float[]{0.0f, 1.0f}, new int[]{tableSize});
        int[] nArray2 = new int[3];
        nArray2[0] = tSby2;
        nArray2[2] = tableSize - tSby2;
        SQUARE = WavetableGenerator.gen7(tableSize, new float[]{-1.0f, -1.0f, 1.0f, 1.0f}, nArray2);
        TRIANGLE = WavetableGenerator.gen7(tableSize, new float[]{0.0f, 1.0f, -1.0f, 0.0f}, new int[]{tSby4, tSby2, tableSize - tSby2 - tSby4});
        int[] nArray3 = new int[3];
        nArray3[0] = tSby4;
        nArray3[2] = tableSize - tSby4;
        QUARTERPULSE = WavetableGenerator.gen7(tableSize, new float[]{-1.0f, -1.0f, 1.0f, 1.0f}, nArray3);
    }

    public static Wavetable saw(int numberOfHarms) {
        float[] content = new float[numberOfHarms];
        int i = 0;
        while (i < numberOfHarms) {
            content[i] = (float)(-2.0 / ((double)(i + 1) * Math.PI) * Math.pow(-1.0, i + 1));
            ++i;
        }
        return WavetableGenerator.gen10(tableSize, content);
    }

    public static Wavetable square(int numberOfHarms) {
        float[] content = new float[numberOfHarms + 1];
        int i = 0;
        while (i < numberOfHarms) {
            content[i] = 1.0f / (float)(i + 1);
            content[i + 1] = 0.0f;
            i += 2;
        }
        return WavetableGenerator.gen10(tableSize, content);
    }

    public static Wavetable triangle(int numberOfHarms) {
        float[] content = new float[numberOfHarms + 1];
        int i = 0;
        while (i < numberOfHarms) {
            content[i] = (float)(Math.pow(-1.0, i / 2) * 8.0 / Math.PI / Math.PI / Math.pow(i + 1, 2.0));
            content[i + 1] = 0.0f;
            i += 2;
        }
        return WavetableGenerator.gen10(tableSize, content);
    }

    public static Wavetable pulse(float dutyCycle) {
        int[] nArray = new int[3];
        nArray[0] = (int)(dutyCycle * (float)tableSize);
        nArray[2] = tableSize - (int)(dutyCycle * (float)tableSize);
        return WavetableGenerator.gen7(tableSize, new float[]{1.0f, 1.0f, -1.0f, -1.0f}, nArray);
    }

    public static Wavetable triangle(float dutyCycle) {
        int a = (int)((double)((float)tableSize * dutyCycle) * 0.5);
        return WavetableGenerator.gen7(tableSize, new float[]{0.0f, 1.0f, 0.0f, -1.0f, 0.0f}, new int[]{a, a, tSby2 - a, tableSize - tSby2 - a});
    }

    public static Wavetable saw(float dutyCycle) {
        int a = (int)((float)tableSize * dutyCycle);
        return WavetableGenerator.gen7(tableSize, new float[]{1.0f, 0.0f, -1.0f}, new int[]{a, tableSize - a});
    }

    public static Wavetable square(float dutyCycle) {
        return Waves.pulse(dutyCycle);
    }

    public static Wavetable randomNHarms(int numberOfHarms) {
        float[] harmAmps = new float[numberOfHarms];
        int i = 0;
        while (i < numberOfHarms) {
            harmAmps[i] = (float)Math.random() * 2.0f - 1.0f;
            ++i;
        }
        Wavetable builtWave = WavetableGenerator.gen10(tableSize, harmAmps);
        builtWave.normalize();
        return builtWave;
    }

    public static Wavetable randomNOddHarms(int numberOfHarms) {
        float[] harmAmps = new float[numberOfHarms * 2];
        int i = 0;
        while (i < numberOfHarms) {
            harmAmps[i * 2] = (float)Math.random() * 2.0f - 1.0f;
            harmAmps[i * 2 + 1] = 0.0f;
            ++i;
        }
        Wavetable builtWave = WavetableGenerator.gen10(tableSize, harmAmps);
        builtWave.normalize();
        return builtWave;
    }

    public static Wavetable randomNoise() {
        float[] builtArray = new float[tableSize];
        int i = 0;
        while (i < builtArray.length) {
            builtArray[i] = (float)Math.random() * 2.0f - 1.0f;
            ++i;
        }
        Wavetable builtWave = new Wavetable(builtArray);
        builtWave.normalize();
        return builtWave;
    }

    public static Wavetable add(float[] amps, Wavetable ... waves) {
        if (amps.length != waves.length) {
            System.out.println("add() : amplitude array size must match the number of waveforms...");
            System.out.println("...returning the first waveform ");
            return waves[0];
        }
        float[] accumulate = new float[tableSize];
        int i = 0;
        while (i < waves.length) {
            waves[i].scale(amps[i]);
            int j = 0;
            while (j < tableSize) {
                int n = j;
                accumulate[n] = accumulate[n] + waves[i].get(j);
                ++j;
            }
            ++i;
        }
        return new Wavetable(accumulate);
    }
}

